/*
 * mbed library program
 *  LCD Module: 40 characters × 4 lines, F-STN / Black&White-mode
 *  C-51849NFJ-SLW-ADN by KYOCERA Industrial Ceramics Corporation - Display Division.
 *
 * Copyright (c) 2015 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: April     27th, 2015
 *      Revised: April     28th, 2015
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "C51849NFJ.h"

#define TWHE        (0.000002f)
#define E1_CLK()    {wait(TWHE); _e1 = 1; wait(TWHE); _e1 = 0;}
#define E2_CLK()    {wait(TWHE); _e2 = 1; wait(TWHE); _e2 = 0;}
//#define WT_1R64MS() {wait(0.00164f);}  // 1.64mS
#define WT_40US()   {wait(0.00004f);}  // 40uS
#define WT_5MS()    {wait(0.005f);}    // 5mS
//#define WT_100US()  {wait(0.0001f);}   // 100uS
#define WT_15MS()   {wait(0.015f);}    // 15mS
#define SET4BIT(x)  {_d = x;}

C51849NFJ::C51849NFJ(PinName rs, PinName e_1, PinName e_2, PinName d4, PinName d5,
                     PinName d6, PinName d7) : _rs(rs), _e1(e_1), _e2(e_2), _d(d4, d5, d6, d7)
{
    _e1 = _e2 = 0;
    _rs = 0;
    WT_15MS();
    SET4BIT(3);
    E1_CLK();
    E2_CLK();
    WT_5MS();
    SET4BIT(3);
    E1_CLK();
    E2_CLK();
    WT_40US();
    SET4BIT(3);
    E1_CLK();
    E2_CLK();
    WT_40US();
    SET4BIT(2);
    E1_CLK();
    E2_CLK();
    WT_40US();
    writeCMD(0x28);
    WT_40US();
    writeCMD(0x0C);
    WT_40US();
    writeCMD(0x06);
    cls();
}

void C51849NFJ::character(int column, int row, int c)
{
    int16_t a = address(column, row);
    writeCMD((int)(a & 0xff));
    _rs = 1;
    SET4BIT(c >> 4);
    if ((a & 0x100)){
        E2_CLK();
        WT_40US();
        SET4BIT(c & 0xf);
        E2_CLK();
    } else {
        E1_CLK();
        WT_40US();
        SET4BIT(c & 0xf);
        E1_CLK();
    }
    WT_40US();
}

void C51849NFJ::cls()
{
    writeCMD(0x01); // cls, and set cursor to 0
    WT_5MS();
    locate(0, 0);
}

void C51849NFJ::locate(int column, int row)
{
    _column = column;
    _row = row;
}

int C51849NFJ::_putc(int value)
{
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= 4) {
            _row = 0;
        }
    } else {
        character(_column, _row, value);
        _column++;
        if (_column >= 40) {
            _column = 0;
            _row++;
            if (_row >= 4) {
                _row = 0;
            }
        }
    }
    return value;
}

int C51849NFJ::_getc()
{
    return -1;
}

void C51849NFJ::writeCMD(int command)
{
    _rs = 0;
    SET4BIT(command >> 4);
    E1_CLK();
    E2_CLK();
    WT_40US();
    SET4BIT(command & 0xf);
    E1_CLK();
    E2_CLK();
    WT_40US();
}

int16_t C51849NFJ::address(int column, int row)
{
    if (column >= 40){
        row += 1;
        if (row >= 4){
            row = 0;
        }
    }
    switch (row) {
        case 0:
            return 0x0080 + column;
        case 1:
            return 0x00c0 + column;
        case 2:
            return 0x0180 + column;
        case 3:
            return 0x01c0 + column;
        default:
            return 0x0080;
    }
}
