/*
 * mbed Application program
 *
 *  Copyright (c) 2016 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:  Feburary   1st, 2016
 *      Revised:  Feburary  18th, 2016
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

    //---------------------------------------------------------------------------------
    //  Something new and try new functions
    //---------------------------------------------------------------------------------
#define NRF_RTC2_BASE                   0x40024000UL
#define NRF_RTC2                        ((NRF_RTC_Type            *) NRF_RTC2_BASE)
#define MAX_RTC_TASKS_DELAY     47  /**< Maximum delay until an RTC task is executed. */
 
case '1' :
    step_by_step('1');
    sd_power_system_off();
    step_by_step('2');
    NRF_RTC2->PRESCALER = 0; /* for no pre-scaling. */
    NRF_RTC2->TASKS_START = 1;
    n = NRF_RTC2->COUNTER;
    wait(0.1);
    if ( n == NRF_RTC2->COUNTER){
        PRINTF("RTC2 is not running\r\n");
    } else {
        PRINTF("RTC2 is running & counter = %d\r\n", n);
    }
                step_by_step('3');
    n = NRF_RTC2->COUNTER;
    wait(0.1);
    if ( n == NRF_RTC2->COUNTER){
        PRINTF("RTC2 is not running\r\n");
    } else {
        PRINTF("RTC2 is running & counter = %d\r\n", n);
    }
                step_by_step('4');
    n = NRF_RTC0->COUNTER;
    wait(0.1);
    if ( n == NRF_RTC0->COUNTER){
        PRINTF("RTC0 is not running\r\n");
    } else {
        PRINTF("RTC0 is running & counter = %d\r\n", n);
    }
    n = NRF_RTC1->COUNTER;
    wait(0.1);
    if ( n == NRF_RTC1->COUNTER){
        PRINTF("RTC1 is not running\r\n");
        NRF_RTC1->PRESCALER = 0; /* for no pre-scaling. */
        NRF_RTC1->TASKS_START = 1;
        wait(0.5);
        n = NRF_RTC1->COUNTER;
        wait(0.1);
        if ( n == NRF_RTC1->COUNTER){
            PRINTF("RTC1 is not running\r\n");
        } else {
            PRINTF("RTC1 is running & counter = %d\r\n", n);
        }
    } else {
        PRINTF("RTC1 is running & counter = %d\r\n", n);
    }                
    step_by_step('2');                
    NRF_POWER->SYSTEMOFF = 1;         
    #if 0
    NRF_CLOCK->TASKS_HFCLKSTOP = 0xffffffff;
    NRF_CLOCK->TASKS_LFCLKSTOP = 0xffffffff;
    step_by_step('1');
    sd_power_system_off();
    //*(uint32_t *)0x40004ffc = 0;
    //shutdown();
    //softdevice_handler_sd_disable();
    PRINTF("POWER=0x%x",NRF_RADIO->POWER);
    put_rn();
    if (NRF_RADIO->POWER){
        PRINTF("Radio power is still enabled");
    } else {
        PRINTF("Radio power is disabled");
    }
    put_rn();
    step_by_step('2');
    NRF_CLOCK->TASKS_HFCLKSTOP = 1;
    step_by_step('1');
    NRF_RADIO->POWER = 0;
    //NRF_POWER->SYSTEMOFF = 1;
    //sd_power_system_off();
    NRF_SPI0->POWER =0;
    NRF_SPI1->POWER =0;
    NRF_TWI0->POWER =0;
    NRF_TWI1->POWER =0;
    step_by_step('4');
    //step_by_step('x');
    //NRF_UART0->ENABLE = 0;  // Disable UART
    step_by_step('2');
    NRF_SPI0->ENABLE =0;
    NRF_SPI1->ENABLE =0;
    NRF_TWI0->ENABLE =0;
    NRF_TWI1->ENABLE =0;
    step_by_step('3');
    NRF_POWER->RAMON = 0;
    NRF_POWER->RAMONB = 0;
    step_by_step('5');
    sd_power_system_off();
    //step_by_step('6');
    NRF_POWER->SYSTEMOFF = 1;
    NRF_POWER->INTENCLR = 0;
    #endif
    while(true){
       sleep();
    }
    //break;
case '2' :
#if 1
    step_by_step('a');              
    // Stop Radio
    NRF_RADIO->SHORTS          = 0;
    NRF_RADIO->EVENTS_DISABLED = 0;
    NRF_RADIO->TEST            = 0;
    NRF_RADIO->TASKS_DISABLE   = 1;
    while (NRF_RADIO->EVENTS_DISABLED == 0){
        ;// Do nothing.
    }
    NRF_RADIO->EVENTS_DISABLED = 0;
    // Set RTC1 for wake-up
    NVIC_ClearPendingIRQ(RTC1_IRQn);
    NVIC_DisableIRQ(RTC1_IRQn);
    NRF_RTC1->TASKS_STOP = 1;
    nrf_delay_us(MAX_RTC_TASKS_DELAY);
    NRF_RTC1->TASKS_CLEAR = 1;
    nrf_delay_us(MAX_RTC_TASKS_DELAY);
    NRF_RTC1->INTENCLR = RTC_INTENSET_COMPARE0_Msk;
    NRF_RTC1->EVTENCLR = RTC_EVTEN_COMPARE0_Msk;
    NRF_RTC1->INTENCLR = RTC_INTENSET_OVRFLW_Msk;
    NRF_RTC1->EVTENCLR = RTC_EVTEN_OVRFLW_Msk;
    NRF_RTC1->EVENTS_COMPARE[0] = 0;
    NRF_RTC1->EVTENCLR = 0x000f0003; // all clear
    NRF_RTC1->EVTENSET = RTC_EVTEN_COMPARE0_Msk;
#if 0
    do {
        NRF_RTC1->PRESCALER = 4095;
    } while (NRF_RTC1->PRESCALER != 4095);
#else
    NRF_RTC1->PRESCALER = 4095;
#endif
    // Set wake-up time
    NRF_RTC1->CC[0] = 50;
    // GPIOE
#if 0
    NRF_GPIO->PIN_CNF[21] =   (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                            | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                            | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                            | (GPIO_PIN_CNF_INPUT_Connect << GPIO_PIN_CNF_INPUT_Pos)
                            | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);
#endif
    NRF_GPIOTE->CONFIG[0] =   (GPIOTE_CONFIG_POLARITY_LoToHi << GPIOTE_CONFIG_POLARITY_Pos)
                            | (21 << GPIOTE_CONFIG_PSEL_Pos) 
                            | (GPIOTE_CONFIG_MODE_Task << GPIOTE_CONFIG_MODE_Pos);   
    // Set PPI
    NRF_PPI->CH[0].EEP = (uint32_t)&NRF_RTC1->EVENTS_COMPARE[0];
    NRF_PPI->CH[0].TEP = (uint32_t)&NRF_GPIOTE->TASKS_OUT[0];
    // Enable only PPI channels 0
    NRF_PPI->CHEN = PPI_CHEN_CH0_Enabled << PPI_CHEN_CH0_Pos;
    // Restart RTC1
    NRF_RTC1->TASKS_START = 1;
    nrf_delay_us(MAX_RTC_TASKS_DELAY);
    // DEBUG
    PRINTF("NRF_RTC1->PRESCALER=0x%x\r\n", NRF_RTC1->PRESCALER);
    PRINTF("NRF_RTC1->EVTEN=0x%x\r\n", NRF_RTC1->EVTEN);
    PRINTF("NRF_RTC1->COUNTER=0x%x\r\n", NRF_RTC1->COUNTER);
    PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=0x%x\r\n", NRF_RTC1->EVENTS_COMPARE[0]);
    PRINTF("NRF_RTC1->CC[0]=0x%x\r\n", NRF_RTC1->CC[0]);
    do {
        PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=");
        PRINTF("%d", NRF_RTC1->EVENTS_COMPARE[0]);
        PRINTF(" %d", NRF_RTC1->CC[0]);
        PRINTF(" %d\r\n", NRF_RTC1->COUNTER);
        nrf_delay_us(125000);
    } while(NRF_RTC1->EVENTS_COMPARE[0] == 0);
    PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=");
    PRINTF("%d", NRF_RTC1->EVENTS_COMPARE[0]);
    PRINTF(" %d", NRF_RTC1->CC[0]);
    PRINTF(" %d\r\n", NRF_RTC1->COUNTER);
    step_by_step('b');
    SCB->AIRCR = 0x05fa0004;    // System RESET!!
    // Not come here (Just in case)
    deepsleep();
#else
    step_by_step('a');              
    // Internal 32kHz RC
    //NRF_CLOCK->LFCLKSRC = CLOCK_LFCLKSRC_SRC_RC << CLOCK_LFCLKSRC_SRC_Pos;           
    // Start the 32 kHz clock, and wait for the start up to complete
    //NRF_CLOCK->EVENTS_LFCLKSTARTED = 0;
    //NRF_CLOCK->TASKS_LFCLKSTART = 1;
    //while(NRF_CLOCK->EVENTS_LFCLKSTARTED == 0);
    // Configure the RTC to run at 2 second intervals, and make sure COMPARE0 generates an interrupt (this will be the wakeup source)
    NVIC_DisableIRQ(RTC0_IRQn);
    NRF_RTC1->TASKS_STOP = 1;
    // GPIOE
#if 0
    NRF_GPIO->PIN_CNF[21] =   (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                            | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                            | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                            | (GPIO_PIN_CNF_INPUT_Connect << GPIO_PIN_CNF_INPUT_Pos)
                            | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);
#endif    
    NRF_GPIOTE->CONFIG[0] =   (GPIOTE_CONFIG_POLARITY_LoToHi << GPIOTE_CONFIG_POLARITY_Pos)
                            | (21 << GPIOTE_CONFIG_PSEL_Pos) 
                            | (GPIOTE_CONFIG_MODE_Task << GPIOTE_CONFIG_MODE_Pos);
    // RTC1
    NRF_RTC1->TASKS_STOP = 1;
    NRF_RTC1->EVENTS_COMPARE[0] = 0;
    NRF_RTC1->EVTENCLR = 0x000f0003; // all clear
    NRF_RTC1->EVTENSET = RTC_EVTEN_COMPARE0_Msk;
    NRF_RTC1->TASKS_CLEAR = 1;    
    NRF_RTC1->CC[0] = 100;
    NRF_RTC1->PRESCALER = 4095;
    do {
        NRF_RTC1->TASKS_STOP = 1; 
        NRF_RTC1->PRESCALER = 4095;
        PRINTF("Retry PRESCALER setting\r\n");
    } while (NRF_RTC1->PRESCALER != 4095);    
    PRINTF("NRF_RTC1->PRESCALER=0x%x\r\n", NRF_RTC1->PRESCALER);
    PRINTF("NRF_RTC1->EVTEN=0x%x\r\n", NRF_RTC1->EVTEN);
    PRINTF("NRF_RTC1->COUNTER=0x%x\r\n", NRF_RTC1->COUNTER);
    PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=0x%x\r\n", NRF_RTC1->EVENTS_COMPARE[0]);
    PRINTF("NRF_RTC1->CC[0]=0x%x\r\n", NRF_RTC1->CC[0]);
    // PPI
    NRF_PPI->CH[0].EEP = (uint32_t)&NRF_RTC1->EVENTS_COMPARE[0];
    NRF_PPI->CH[0].TEP = (uint32_t)&NRF_GPIOTE->TASKS_OUT[0];
    // Enable only PPI channels 0
    NRF_PPI->CHEN = PPI_CHEN_CH0_Enabled << PPI_CHEN_CH0_Pos;
    NRF_RTC1->TASKS_START = 1;
    do {
        PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=");
        PRINTF("%d", NRF_RTC1->EVENTS_COMPARE[0]);
        PRINTF(" %d", NRF_RTC1->CC[0]);
        PRINTF(" %d\r\n", NRF_RTC1->COUNTER);
    } while(NRF_RTC1->EVENTS_COMPARE[0] == 0);
    PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=");
    PRINTF("%d", NRF_RTC1->EVENTS_COMPARE[0]);
    PRINTF(" %d", NRF_RTC1->CC[0]);
    PRINTF(" %d\r\n", NRF_RTC1->COUNTER);
    step_by_step('b');
    SCB->AIRCR = 0x05fa0004;    // System RESET!!
    // Not come here (Just in case)
    deepsleep();
#endif
#if 0       
    // Configure the RAM retention parameters
    NRF_POWER->RAMON = POWER_RAMON_ONRAM0_RAM0On   << POWER_RAMON_ONRAM0_Pos
                     | POWER_RAMON_ONRAM1_RAM1Off  << POWER_RAMON_ONRAM1_Pos
                     | POWER_RAMON_OFFRAM0_RAM0Off << POWER_RAMON_OFFRAM0_Pos
                     | POWER_RAMON_OFFRAM1_RAM1Off << POWER_RAMON_OFFRAM1_Pos;
    while(1) {
        __WFI();
        //NRF_RTC1->TASKS_STOP = 1;
    }
    break;
#endif
#if 0
case '3' :
    step_by_step('x');
    p_out = 1;
    step_by_step('y');
    p_out = 0;
    step_by_step('z');
    for (uint8_t n =100; n > 0; n--){
        p_out = 1;
        wait(0.1);
        p_out = 0;
        wait(0.1);
    }
    break;
#endif              
