/*
 * mbed Application program
 *
 *  Copyright (c) 2016,'17 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:  Feburary   1st, 2016
 *      Revised:  January    8th, 2017
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#if defined(TARGET_NRF51822)

//  Include ---------------------------------------------------------------------------------------
#include "mbed.h"
#include "debug_common.h"
#include "nrf_soc.h"            // for internal Thermo sensoer
#include "nRF51_Vdd.h"          // Read nRF51 Vdd voltage
#include "nrf_delay.h"

//  Object ----------------------------------------------------------------------------------------
nRF51_Vdd vdd_mon(3.6f, 2.6f);

DigitalOut  p_out(P0_1);

//  Definition ------------------------------------------------------------------------------------

//  RAM -------------------------------------------------------------------------------------------

//  ROM / Constant data ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------
extern void cpu_sys(void);
extern int trx_control(void);
void debug_core(void);
void ble_stack_stop(void);

//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
//  Help Massage
void msg_hlp (void)
{
    PRINTF(mon_msg);
    put_rn();
    PRINTF("  RESET -> Press [Alt]+B");
    put_rn();
    PRINTF("c - CPU VDD & Temp info");
    put_rn();
    PRINTF("l - Low current (Sleep Mode)");
    put_rn();
#if 0
    PRINTF("t - Test Radio module");
    put_rn();
#endif
    PRINTF("s - CPU system info");
    put_rn();
    PRINTF("r - Reset(by Software)");
    put_rn();
    PRINTF("x - Goto HW monitor");
    put_rn();
    PRINTF("q - Return to main");
    put_rn();
    PRINTF("New function (Number 1,2...)");
    put_rn();
    PRINTF("1 - Try new function");
    put_rn();
}

// ---------- Program starts here! ---------------------------------------------------------------
void debug_interface(uint8_t mode)
{
    BAUD(BAUD_RATE);
    if (mode){
            debug_core();
    } else {
        if(READABLE()){
            unsigned char c = GETC();   // dummy read
            debug_core();
        }
    }   
}

void step_by_step(char c)
{
    PRINTF("Waiting key input");
    while (!READABLE()){;}
    PRINTF("--- step %c", c);
    put_rn();
    c = GETC();   // dummy read
}

void debug_core(void)
{
    char *ptr;
    int32_t p_temp;
    float temperature;

    uint32_t n;

    put_rn();
    put_rn();
    PRINTF("%s [Help:'?' key]", mon_msg);
    put_rn();
    for (;;) {
        put_r();
        PUTC('>');
        ptr = linebuf;
        get_line(ptr, sizeof(linebuf));
        put_r();
        switch (*ptr++) {
                //---------------------------------------------------------------------------------
                //  CPU VDD Voltage and Chip temperature
                //---------------------------------------------------------------------------------
            case 'c' :
                NRF_TEMP->TASKS_START = 1;
                while (NRF_TEMP->EVENTS_DATARDY == 0){;}
                NRF_TEMP->EVENTS_DATARDY = 0;
                if ((NRF_TEMP->TEMP & 0x00000200) != 0){
                    p_temp = (NRF_TEMP->TEMP | 0xFFFFFC00);
                } else {
                    p_temp = NRF_TEMP->TEMP;  
                }
                NRF_TEMP->TASKS_STOP = 1; /** Stop the temperature measurement. */
                temperature = float(p_temp) / 4; // Original = float(p_temp)/4.0f - 16.0f;
                PRINTF("nRF51\r\nChip temperature: %+4.1fdegC", temperature);
                put_rn();
                // Vdd voltage
                PRINTF("Vdd: %4.3fV", vdd_mon.read_real_value());
                put_rn();
                break;
#if 0   // Nobember   1st, 2016
        // Timer1 IRQ handaler dupulicated error is occured dur to revision change.
        // I cannot control Radio module.
                //---------------------------------------------------------------------------------
                //  Test Radio module
                //---------------------------------------------------------------------------------
            case 't' :
                trx_control();
                break;
#endif
                //---------------------------------------------------------------------------------
                //  Something new and try new functions
                //---------------------------------------------------------------------------------

                // Please see following file
                #include "debugging_nRF51.h"
          
                //---------------------------------------------------------------------------------
                //  Go to Low current (Sleep mode)
                //---------------------------------------------------------------------------------
            case 'l' :
                PRINTF("Enter Sleep mode (Please push RESET button on the board");
                PRINTF(" or Press [Alt]+B from PC)");
                put_rn();
                while(true){
                    sleep();
                    //__WFI();
                    //__WFE();
                }
                //       SCB->AIRCR = 0x05fa0004;    // System RESET!!
                //break;
                //---------------------------------------------------------------------------------
                //  CPU system info
                //---------------------------------------------------------------------------------
            case 's' :
                cpu_sys();
                break;
                //---------------------------------------------------------------------------------
                //  System reset
                //---------------------------------------------------------------------------------
            case 'r' :
                SCB->AIRCR = 0x05fa0004;    // System RESET!!
                // Not come here (Just in case)
                deepsleep();
                break;
                //---------------------------------------------------------------------------------
                //  help
                //---------------------------------------------------------------------------------
            case '?' :
                msg_hlp();
                break;
                //---------------------------------------------------------------------------------
                //  Go to special command
                //---------------------------------------------------------------------------------
            case 'x' :
                mon_hw();
                PRINTF("->Came back monitor\r\n");
                break;
                //---------------------------------------------------------------------------------
                //  Go back to main()
                //---------------------------------------------------------------------------------
            case 'q' :        // Quit
                PRINTF("\rReturn to main\r\n");
                //PRINTF("cannot control anymore from here\r\n");
                return;
                //---------------------------------------------------------------------------------
                //    no support
                //---------------------------------------------------------------------------------
            default:
                PUTC('?');
                put_rn();
                break;
        }
    }
}

#endif  // defined(TARGET_NRF51822)


