/*
 * Mbed Application program
 *  ------- Test program for UART pin assignment -------
 *   Tested on Switch Science Mbed TY51822r3
 *
 *   Copyright (c) 2016,'17 Kenji Arai / JH1PJL
 *    http://www.page.sannet.ne.jp/kenjia/index.html
 *    http://mbed.org/users/kenjiArai/
 *      Created: May        3rd, 2016   // Base:BLE_I2C_pin_assign
 *      Revised: September  1st, 2017
 *
 */
/*
    /---------------------\
    | nRF51822/TY51822r3  |
    |                     |
    |   UART TX(any pin)  |----------]  Direct connect TX and RX line
    |                     |          |
    |   UART RX(any pin)  |----------]
    |                     |
    \---------------------/
 */

//  Include --------------------------------------------------------------------
#include    "mbed.h"

//  Definition -----------------------------------------------------------------
#define     ON_THREAD_MODE

#define     PIN_MODE   4   // Select 1 to 5 for UART pin assign

//  Constructor ----------------------------------------------------------------
#ifdef      ON_THREAD_MODE  // under some threads

DigitalOut  myled(LED1);
Thread      th0;
Thread      th1;
Mutex       mutex;

#else       // ON_THREAD_MODE

DigitalOut myled(LED1);
#if   (PIN_MODE == 0)
Serial uart(USBTX, USBRX);
#elif (PIN_MODE == 1)
Serial uart(P0_0, P0_1);
#elif (PIN_MODE == 2)
Serial uart(P0_28, P0_29);
#elif (PIN_MODE == 3)
Serial uart(P0_3, P0_2);
#elif (PIN_MODE == 4)
Serial uart(P0_12, P0_13);
#elif (PIN_MODE == 5)
Serial uart(P0_23, P0_22);
#else       // PIN_MODE
Serial uart(USBTX, USBRX);
#endif      // PIN_MODE

#endif      // ON_THREAD_MODE

//  RAM ------------------------------------------------------------------------
volatile uint32_t number = 0;

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
#ifdef      ON_THREAD_MODE  // under some threads

void pc_com_thread(void);
void uart_com_thread(void);

#endif      // ON_THREAD_MODE

//------------------------------------------------------------------------------
//  Control Program on RTOS(mbed-os5)
//------------------------------------------------------------------------------
#ifdef      ON_THREAD_MODE  // under some threads

#warning "you are selecting this main function"
int main() {
    th0.start(pc_com_thread);
    th1.start(uart_com_thread);
    while(true) {
        Thread::wait(osWaitForever);
    }
}

void uart_com_thread()
{
#if   (PIN_MODE == 1)
    Serial uart(P0_0,  P0_1);
#elif (PIN_MODE == 2)
    Serial uart(P0_28, P0_29);
#elif (PIN_MODE == 3)
    Serial uart(P0_3,  P0_2);
#elif (PIN_MODE == 4)
    Serial uart(P0_12, P0_13);
#elif (PIN_MODE == 5)
    Serial uart(P0_14, P0_15;
#else
#error "Please select 1 to 5 for PIN_MODE"
#endif
    // If you see LED blinking, you may have an error.
    while(true){
        for (char c = '!'; c < '~'; c++){
            mutex.lock();
            uart.putc(c);
            Thread::wait(5);           // 5 mS
            while (uart.readable() == 0){;} // wait for loopback
            if (uart.getc() == c){
                ++number;
                myled = 0;
            } else {
                myled = 1;
                Thread::wait(10);
                myled = 0;
            }
            mutex.unlock();
        }
        Thread::wait(100);     // 100 mS
    }
}

void pc_com_thread()
{
    uint32_t n = 0;

    while(true){
        mutex.lock();
        Serial pc(USBTX, USBRX);
        pc.printf("test(uart1_thread) %d\r\n", n++);
        pc.printf("total number of TX&RX communication %d\r\n", number); 
#if   (PIN_MODE == 1)
        Serial uart(P0_0,  P0_1);
#elif (PIN_MODE == 2)
        Serial uart(P0_28, P0_29);
#elif (PIN_MODE == 3)
        Serial uart(P0_3,  P0_2);
#elif (PIN_MODE == 4)
        Serial uart(P0_12, P0_13);
#elif (PIN_MODE == 5)
        Serial uart(P0_14, P0_15;
#else
#error "Please select 1 to 5 for PIN_MODE"
#endif
        mutex.unlock();
        Thread::wait(5000);     // 5 sec
    }
}

//------------------------------------------------------------------------------
//  Control Program as none RTOS mode
//------------------------------------------------------------------------------
#else       // ON_THREAD_MODE

#warning "You are selecting this main function"
// If you see LED blinking, you may have an error.
int main() {
    while(true) {
        for (char c = '!'; c < '~'; c++){
            uart.putc(c);
            while (uart.readable() != 0){
                myled = !myled;
                wait(0.2f);
            }
            if (uart.getc() == c){
                myled = 0;
            } else {
                myled = !myled;
            }
            wait(0.01f);
        } 
    }
}

#endif      // ON_THREAD_MODE
