/*
 * mbed Application program
 *  ------- Test program for I2C pin assignment -----------------------------------------
 *      Tested on Switch Science mbed TY51822r3
 *      Tested LCD module AQM0802A-RN-GBW, Akizuki 8 characters X 2 lines
 *              http://akizukidenshi.com/catalog/g/gP-06669/
 *
 *      Copyright (c) 2016 Kenji Arai / JH1PJL
 *          http://www.page.sannet.ne.jp/kenjia/index.html
 *          http://mbed.org/users/kenjiArai/
 *              Created: May        2nd, 2016
 *              Revised: May        2nd, 2016
 *
 */

#include "mbed.h"
#include "TextLCD.h"

#define PIN_MODE   1   // 0 to 4

#if   (PIN_MODE == 0)
I2C i2c(I2C_SDA0, I2C_SCL0);   // SDA, SCL
#elif (PIN_MODE == 1)
I2C i2c(P0_0, P0_1);
#elif (PIN_MODE == 2)
I2C i2c(P0_28, P0_29);
#elif (PIN_MODE == 3)
I2C i2c(P0_3, P0_2);
#elif (PIN_MODE == 4)
I2C i2c(P0_2, P0_3);
#else
I2C i2c(I2C_SDA0, I2C_SCL0);
#endif

TextLCD_I2C_N   lcd(&i2c, ST7036_SA2, TextLCD::LCD8x2, NC, TextLCD::ST7032_3V3);

int main() {
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    lcd.locate(0, 0);    // 1st line top
    //          12345678
    lcd.printf("TY51822r");
    lcd.locate(0, 1);    // 2nd line top
    //        12345678
    lcd.puts("Test I2C");
    lcd.setContrast(0x14);
    wait(3.0);
    uint32_t n = 0;
    uint8_t  num = PIN_MODE;
    while(1) {
        lcd.locate(n%8, 1);    // 2nd line top
        lcd.printf("*.......");
        lcd.locate(0, 0);    // 1st line top
        lcd.printf("%u: %5u", num, n++);
        wait(1.0); 
    }
}
