/*
 * Mbed Application program
 *  Nano 33 BLE Sense board runs on mbed-OS6
 *  HTS221 -> Capacitive digital sensor for relative humidity and temperature
 *      by STMicroelectronics
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *      Started:    January   22nd, 2020
 *      Revised:    February  28th, 2021
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_4_CHECK_HTS221
#ifdef EXAMPLE_4_CHECK_HTS221

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "nano33blesense_iodef.h"
#include    "HTS221.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
DigitalOut      sen_pwr(PIN_VDD_ENV, 1);
DigitalOut      i2c_pullup(PIN_I2C_PULLUP, 1);
I2C             i2c(PIN_SDA1, PIN_SCL1);
HTS221          *hum = NULL;
Timer           t;

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//  subroutin (must be at this below line and do NOT change order) -------------
#include    "usb_serial_as_stdio.h"
#include    "check_revision.h"
#include    "common.h"

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    HTS221::HTS221_data_t   hum_data;

    usb_serial_initialize();
    print_revision();
    i2c_pullup = 1;
    sen_pwr = 1;
    print_usb("Check LSM9DS1\r\n");
    ThisThread::sleep_for(200ms);
    //  check I2C line
    check_i2c_connected_devices();
    hum = new HTS221(PIN_SDA1, PIN_SCL1,HTS221::HTS221_ADDRESS, 400000);
    hum->HTS221_GetDeviceID (&hum_data);
    uint8_t id = hum_data.deviceID;
    if (id == HTS221::WHO_AM_I_VALUE) {
        print_usb("HTS221 is ready. ID = 0x%x\r\n", id);
    } else {
        print_usb("HTS221 is NOT ready. return value = 0x%x\r\n", id);
    }
    uint32_t n = 0;
    while(true) {
        t.reset();
        t.start();
        hum->HTS221_SetOneShot();
        do {
            thread_sleep_for(2);
            hum->HTS221_GetOneShot(&hum_data);
        } while(hum_data.one_shot == HTS221::CTRL_REG2_ONE_SHOT_WAITING);
        hum->HTS221_GetCalibrationCoefficients (&hum_data);
        hum->HTS221_GetTemperature(&hum_data);
        hum->HTS221_GetHumidity(&hum_data);
        print_usb("Temperature:,%0.1f,[degC],RH:,%0.1f,[%%],",
                    hum_data.temperature, hum_data.humidity);
        ++n;
        uint32_t passed_time = chrono::duration_cast<chrono::milliseconds>(
                               t.elapsed_time()).count();
        print_usb("processing time:,%2d,[ms],count:,%4d\r\n", passed_time, n);
        if (passed_time < 999){
            ThisThread::sleep_for(chrono::milliseconds(1000 - passed_time));
        }
    }
}

#endif // EXAMPLE_4_CHECK_HTS221