/*
 * Mbed Application program
 *  Nano 33 BLE Sense board runs on mbed-OS6
 *  LSM9DS1 -> iNEMO inertial module:
 *    3D accelerometer, 3D gyroscope, 3D magnetometer
 *      by STMicroelectronics
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *      Started:    January   22nd, 2020
 *      Revised:    February  28th, 2021
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_2_CHECK_LSM9DS1
#ifdef EXAMPLE_2_CHECK_LSM9DS1

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "nano33blesense_iodef.h"
#include    "LSM9DS1.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
DigitalOut      sen_pwr(PIN_VDD_ENV, 1);
DigitalOut      i2c_pullup(PIN_I2C_PULLUP, 1);
I2C             i2c(PIN_SDA1, PIN_SCL1);
LSM9DS1         *imu = NULL;
Timer           t;

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//  subroutin (must be at this below line and do NOT change order) -------------
#include    "usb_serial_as_stdio.h"
#include    "check_revision.h"
#include    "common.h"

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    usb_serial_initialize();
    print_revision();
    i2c_pullup = 1;
    sen_pwr = 1;
    print_usb("Check LSM9DS1\r\n");
    ThisThread::sleep_for(200ms);
    imu = new LSM9DS1(PIN_SDA1, PIN_SCL1);
    uint16_t reg = imu->begin();
    print_usb("IMU(LSM9DS1) 0x%x\r\n", reg);
    imu->calibration();
    //  check I2C line
    check_i2c_connected_devices();
    if (reg == 0x683d){
        print_usb("ACC+GYR+MAG are ready!\r\n");
    } else {
        print_usb("ACC+GYR+MAG are NOT ready!\r\n");
    }
    uint32_t n = 0;
    while(true) {
        t.reset();
        t.start();
        imu->readAccel();
        imu->readGyro();
        imu->readMag();
        imu->readTemp();
        print_usb("acc=,%+5.3f,%+5.3f,%+5.3f,", imu->ax, imu->ay, imu->az);
        print_usb("gyr=,%+8.3f,%+8.3f,%+8.3f,", imu->gx, imu->gy, imu->gz);
        print_usb("mag=,%+5.3f,%+5.3f,%+5.3f,", imu->mx, imu->my, imu->mz);
        print_usb("temperature=,%+5.1f,", imu->temperature_c);
        ++n;
        uint32_t passed_time = chrono::duration_cast<chrono::milliseconds>(
                               t.elapsed_time()).count();
        print_usb("processing time:,%2d,[ms],count:,%4d\r\n", passed_time, n);
        if (passed_time < 199){
            ThisThread::sleep_for(chrono::milliseconds(200 - passed_time));
        }
    }
}

#endif // EXAMPLE_2_CHECK_LSM9DS1