/*
 * Mbed Application program
 *  Nano 33 BLE Sense board runs on mbed-OS6
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *      Started:    January   22nd, 2020
 *      Revised:    March      1st, 2021
 */

/*
    You can select several examples as followings.
    0.  0_Blinky_LED
        LED Blinky
    1.  1_check_I2C_devices
        Check sensors connected to I2C line
    2.  2_check_LSM9DS1
        iNEMO inertial module:3D accelerometer, 3D gyroscope, 3D magnetometer
    3.  3_check_LPS22HB
        MEMS nano pressure sensor:260-1260 hPa absolute Digital output barometer
    4.  4_check_HTS221
        Capacitive digital sensor for relative humidity and temperature
    5.  5_Combined_enviromental_sensors
        LSM9DS1+LPS22HB+HTS221
    6.  6_check_APDS_9960
        Digital Proximity, Ambient Light, RGB and Gesture Sensor

    -> PLEASE Open Nano 33 BLE board Virtual Communication line from PC
 */
#define EXAMPLE_NUMBER      0       // select 0 to 6

//----------------- You don't need any modification ----------------------------
#if EXAMPLE_NUMBER == 0
#   define EXAMPLE_0_BLINKY_LED
#   warning "Select 0_Blinky_LED"
#elif EXAMPLE_NUMBER == 1
#   define EXAMPLE_1_CHECK_I2C_DEVICES
#   define USE_COMMON_FUNCTION
#   warning "Select 1_Check_I2C_devices"
#elif EXAMPLE_NUMBER == 2
#   define EXAMPLE_2_CHECK_LSM9DS1
#   define USE_COMMON_FUNCTION
#   warning "Select 2_check_LSM9DS1"
#elif EXAMPLE_NUMBER == 3
#   define EXAMPLE_3_CHECK_LPS22HB
#   define USE_COMMON_FUNCTION
#   warning "Select 3_check_LPS22HB"
#elif EXAMPLE_NUMBER == 4
#   define EXAMPLE_4_CHECK_HTS221
#   define USE_COMMON_FUNCTION
#   warning "Select 4_check_HTS221"
#elif EXAMPLE_NUMBER == 5
#   define EXAMPLE_5_COMB_ENV_SENSORS
#   define USE_COMMON_FUNCTION
#   warning "Select 5_Combined_enviromental_sensors"
#elif EXAMPLE_NUMBER == 6
#   define EXAMPLE_6_CHECK_APDS_9960
#   define USE_COMMON_FUNCTION
#   warning "Select 6_check_APDS_9960"
#else
#   error " Please set 0 to 6 number for EXAMPLE_NUMBER!!"
#endif