/*
 * mbed Application program
 *      Redirect Standard Input/Output
 *
 * Copyright (c) 2021 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    January   13th, 2021
 *      Revised:    February  28th, 2021
 */

//  Include --------------------------------------------------------------------
//#include    "mbed.h"
#include    "USBSerial.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
USBSerial *usb = NULL;

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
/*
    https://cpplover.blogspot.com/2010/03/variadic-templates.html
 */
template <typename ... Args>
void print_usb(const char *format, Args const & ... args)
{
    if (usb == NULL) {
        return;
    } else {
        if (usb->connected() == true) {
            usb->printf(format, args ...);
        }
    }
}

void usb_serial_initialize(void)
{
    usb = new USBSerial;
}

uint8_t readable()
{
    return usb->readable();
}

void putc(uint8_t c)
{
    if (usb == NULL) {
        return;
    } else {
        usb->putc(c);
    }
}

uint8_t getc()
{
    if (usb == NULL) {
        while(true){ ;} // infinit loop
    } else {
        return usb->getc();
    }
}
