/*
 * Mbed Application program
 *  Nano 33 BLE Sense board runs on mbed-OS6
 *      Check I2C control line
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *      Started:    January   22nd, 2020
 *      Revised:    February  28th, 2021
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_1_CHECK_I2C_DEVICES
#ifdef EXAMPLE_1_CHECK_I2C_DEVICES

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "nano33blesense_iodef.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
DigitalOut      sen_pwr(PIN_VDD_ENV, 1);
DigitalOut      i2c_pullup(PIN_I2C_PULLUP, 1);
I2C             i2c(PIN_SDA1, PIN_SCL1);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//  subroutin (must be at this below line and do NOT change order) -------------
#include    "usb_serial_as_stdio.h"
#include    "check_revision.h"
#include    "common.h"

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    usb_serial_initialize();
    print_revision();
    i2c_pullup = 1;
    sen_pwr = 1;
    print_usb("Check I2C line\r\n");
    ThisThread::sleep_for(200ms);
    check_i2c_connected_devices();
    while (true) {
        print_usb("\r\n");
        check_i2c_sensors();
        ThisThread::sleep_for(2s);
    }
}

#endif // EXAMPLE_1_CHECK_I2C_DEVICES