/*
 * APDS-9960
 *  Digital Proximity, Ambient Light, RGB and Gesture Sensor
 *
 * Mbed Application program
 *  Nano 33 BLE Sense board runs on mbed-OS6
 *  Modified by Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *      Started:    February   2nd, 2020
 *      Revised:    February  28th, 2021
 *
 *  Original:
 *      https://os.mbed.com/users/kbhagat6/code/Gesture_User_Interface/
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_6_CHECK_APDS_9960
#ifdef EXAMPLE_6_CHECK_APDS_9960

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "nano33blesense_iodef.h"
#include    "glibr.h"

//  Definition -----------------------------------------------------------------

//  Object ---------------------------------------------------------------------
InterruptIn     apds_int(PIN_APDS_INT);
DigitalOut      sen_pwr(PIN_VDD_ENV, 1);
DigitalOut      i2c_pullup(PIN_I2C_PULLUP, 1);
DigitalOut      led_y(PIN_YELLOW, 0);
DigitalOut      led_g(PIN_GREEN, 0);
DigitalOut      lr(PIN_LR, 1);
DigitalOut      lg(PIN_LG, 1);
DigitalOut      lb(PIN_LB, 1);
I2C             i2c(PIN_SDA1, PIN_SCL1);
glibr           *gesture = NULL;

//  ROM / Constant data --------------------------------------------------------

//  RAM ------------------------------------------------------------------------

//  Function prototypes --------------------------------------------------------
void apds_hit_callback (void);

//  subroutin (must be at this below line and do NOT change order) -------------
#include    "usb_serial_as_stdio.h"
#include    "check_revision.h"
#include    "common.h"

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    bool gerror = false;

    usb_serial_initialize();
    print_revision();
    i2c_pullup = 1;
    sen_pwr = 1;
    print_usb("Check APDS_9960\r\n");
    ThisThread::sleep_for(200ms);
    //  check I2C line
    check_i2c_connected_devices();
    gesture = new glibr(PIN_SDA1, PIN_SCL1);
    if (gesture->ginit()) {
        print_usb("APDS-9960 initialization complete\n\r");
    } else {
        print_usb("Something went wrong during APDS-9960 init\n\r");
        gerror=true;
    }
    // Start running the APDS-9960 gesture sensor engine
    if ( gesture->enableGestureSensor(true) ) {
        print_usb("Gesture sensor is now running\n\r");
    } else {
        print_usb("Something went wrong during gesture sensor init!\n\r");
        gerror=true;
    }
    // set pullup for Interrupt input pin
    apds_int.mode(PullUp);
    // Delay for initial pullup to take effect
    ThisThread::sleep_for(1ms);
    // Setup Interrupt callback function for a pb hit
    apds_int.fall(&apds_hit_callback);
    // Enable interrut
    apds_int.enable_irq(); 
    while(!(gesture->isGestureAvailable())){        
        ThisThread::sleep_for(200ms);
    }
    int temp;
    while(gerror == false) {
        if (gesture->isGestureAvailable()) {
            if(gesture->isGestureAvailable()){
                temp = gesture->readGesture();
            }
            switch ( temp) {
                case DIR_UP:
                    print_usb("Forward\r\n");
                    break;
                case DIR_DOWN:
                    print_usb("Backward\r\n");
                    break;
                case DIR_LEFT:
                    print_usb("LEFT\r\n");
                    break;
                case DIR_RIGHT:
                    print_usb("RIGHT\r\n");
                    break;
                case 67: 
                    print_usb("Collision\r\n");
                    break;
                case DIR_NEAR:
                    print_usb("NEAR\r\n");
                    break;
                case DIR_FAR:
                    print_usb("FAR\r\n");
                    break;
                default:
                    print_usb("NONE\r\n");
                    break; 
            }
        }
    }
}

void apds_hit_callback (void)
{
    led_y =!led_y;
}

#endif  // EXAMPLE_6_CHECK_APDS_9960