/*
 * Mbed Application program
 *  Nano 33 BLE Sense board runs on mbed-OS6
 *  LPS33HB -> MEMS nano pressure sensor:
 *    260-1260 hPa absolute Digital output barometer
 *      by STMicroelectronics
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *      Started:    January   22nd, 2020
 *      Revised:    February  28th, 2021
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_3_CHECK_LPS22HB
#ifdef EXAMPLE_3_CHECK_LPS22HB

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "nano33blesense_iodef.h"
#include    "LPS22HB.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
DigitalOut      sen_pwr(PIN_VDD_ENV, 1);
DigitalOut      i2c_pullup(PIN_I2C_PULLUP, 1);
I2C             i2c(PIN_SDA1, PIN_SCL1);
LPS22HB         *baro = NULL;
Timer           t;

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//  subroutin (must be at this below line and do NOT change order) -------------
#include    "usb_serial_as_stdio.h"
#include    "check_revision.h"
#include    "common.h"

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    usb_serial_initialize();
    print_revision();
    i2c_pullup = 1;
    sen_pwr = 1;
    print_usb("Check LSM9DS1\r\n");
    ThisThread::sleep_for(200ms);
    //  check I2C line
    check_i2c_connected_devices();
    baro = new LPS22HB(i2c, LPS22HB_G_CHIP_ADDR);
    uint8_t id = baro->read_id();
    if (id == I_AM_LPS22HB) {
        print_usb("LPS22H is ready. ID = 0x%x\r\n", id);
    } else {
        print_usb("LPS22H is NOT ready. return value = 0x%x\r\n", id);
    }
    baro->set_odr();
    uint32_t n = 0;
    while(true) {
        t.reset();
        t.start();
        baro->get();
        while (baro->data_ready() == 0){
                 ThisThread::sleep_for(2ms);
        }
        print_usb("Pressure:,%6.1f,[hPa],Temperature:,%+4.1f,[degC],",
                  baro->pressure(), baro->temperature());
        ++n;
        uint32_t passed_time = chrono::duration_cast<chrono::milliseconds>(
                               t.elapsed_time()).count();
        print_usb("processing time:,%2d,[ms],count:,%4d\r\n", passed_time, n);
        if (passed_time < 999){
            ThisThread::sleep_for(chrono::milliseconds(1000 - passed_time));
        }
    }
}

#endif // EXAMPLE_3_CHECK_LPS22HB