/*
 * Mbed Application program
 *  Nano 33 BLE Sense board runs on mbed-OS6
 *      3 LED (Y+G+RGB) blinky
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *      Started:    January   22nd, 2020
 *      Revised:    February  28th, 2021
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_0_BLINKY_LED
#ifdef EXAMPLE_0_BLINKY_LED

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "nano33blesense_iodef.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
DigitalOut      led_y(PIN_YELLOW, 0);
DigitalOut      led_g(PIN_GREEN, 0);
DigitalOut      lr(PIN_LR, 1);
DigitalOut      lg(PIN_LG, 1);
DigitalOut      lb(PIN_LB, 1);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//  subroutin (must be at this below line and do NOT change order) -------------
#include    "usb_serial_as_stdio.h"
#include    "check_revision.h"
#include    "common.h"

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    usb_serial_initialize();
    print_revision();
    ThisThread::sleep_for(100ms);
    uint32_t counter = 0;
    while (true) {
        print_usb("Blinky LED's %u\r\n", ++counter);
        led_y = 1;
        led_g = 0;
        lr = 1;
        lg = 1;
        lb = 1;
        ThisThread::sleep_for(1s);
        led_y = 0;
        led_g = 1;
        lr = 1;
        lg = 1;
        lb = 1;
        ThisThread::sleep_for(1s);
        led_y = 0;
        led_g = 0;
        lr = 0;
        lg = 1;
        lb = 1;
        ThisThread::sleep_for(1s);
        led_y = 0;
        led_g = 0;
        lr = 1;
        lg = 0;
        lb = 1;
        ThisThread::sleep_for(1s);
        led_y = 0;
        led_g = 0;
        lr = 1;
        lg = 1;
        lb = 0;
        ThisThread::sleep_for(1s);
        led_y = 1;
        led_g = 1;
        lr = 0;
        lg = 0;
        lb = 0;
        ThisThread::sleep_for(1s);
        led_y = 0;
        led_g = 0;
        lr = 1;
        lg = 1;
        lb = 1;
        ThisThread::sleep_for(1s);
    }
}

#if 0
/*
    https://cpplover.blogspot.com/2010/03/variadic-templates.html
 */
template <typename ... Args>
void print_usb(const char *format, Args const & ... args)
{
    if (usb == NULL) {
        return;
    } else {
        if (usb->connected() == true) {
            usb->printf(format, args ...);
        }
    }
}

uint8_t readable()
{
    return usb->readable();
}

void putc(uint8_t c)
{
    if (usb == NULL) {
        return;
    } else {
        usb->putc(c);
    }
}

uint8_t getc()
{
    if (usb == NULL) {
        while(true){ ;} // infinit loop
    } else {
        return usb->getc();
    }
}
#endif

#endif  // EXAMPLE_0_BLINKY_LED