#include "MotorDrive.h"
#include "mbed.h"

PwmOut pwm[3] = {PwmOut(PB_2),PwmOut(PB_15),PwmOut(PA_1)};
DigitalOut cw[3] = {DigitalOut(PB_12),DigitalOut(PA_12),DigitalOut(PH_1)};
DigitalOut ccw[3] = {DigitalOut(PB_1),DigitalOut(PB_14),DigitalOut(PA_4)};
DigitalOut dis[3] = {DigitalOut(PA_11),DigitalOut(PB_13),DigitalOut(PC_2)};
//DigitalOut led(D6);
  
//void motor_init();
//void motor(int,char,float);

void motor_init(){
    for(int i=0;i<3;i++){
        cw[i]=0;
        ccw[i]=0;
        dis[i]=0;
        pwm[i].period_us(100);
    }
}

void motor(int motor_num,char direction_of_rotation,float PWM_WRITE){
    pwm[motor_num].write(PWM_WRITE);
    switch(direction_of_rotation){
        case CW:
            ccw[motor_num]=0;
            cw[motor_num]=1;
        break;
        case CCW:
            cw[motor_num]=0;
            ccw[motor_num]=1;
        break;
        case STOP:
            cw[motor_num]=0;
            ccw[motor_num]=0;
        break;
        default:break;
    }
}