#include "DualShock.h"

tDSParm hDS;
static uint8_t recv_data, check = 0;
static Serial* ds_serial;
static float DimensionlessAndBacklash(int8_t dat);
static uint8_t getsum(void *buf, size_t size);

void ReStartDS(void) {
    check = 0;
    recv_data = (*ds_serial).getc();
}

uint8_t InitDS(Serial* f_serial) {

    hDS.BUTTON.ButtonData = 0;
    hDS.ANALOG.LX = 0;
    hDS.ANALOG.LY = 0;
    hDS.ANALOG.RX = 0;
    hDS.ANALOG.RY = 0;
    //huartDS = huart;
    ds_serial = f_serial;

    printf("DualShock connecting check...\r\n");
    ReStartDS();
    printf("DualShock connect successful...\r\n");
    return 0;
}
//&getDSdata
void getDSdata(void) {
    static uint8_t dat[8] = {0};

    recv_data = (*ds_serial).getc();
    dat[check] = recv_data;
    switch (check) {
    case 0:
        if (dat[0] == 0x80) {
            check++;
        }
        break;
    case 7:
        if (dat[7] == (getsum(dat, 7) & 0x7f)) {
            hDS.BUTTON.ButtonHighData = dat[1];
            hDS.BUTTON.ButtonLowData = dat[2];
            hDS.ANALOG.LX = DimensionlessAndBacklash(dat[3]);
            hDS.ANALOG.LY = DimensionlessAndBacklash(dat[4]);
            hDS.ANALOG.RX = DimensionlessAndBacklash(dat[5]);
            hDS.ANALOG.RY = DimensionlessAndBacklash(dat[6]);
        }
        dat[0] = 0;
        check = 0;
        break;
    default:
        check++;
        break;
    }
}

static float DimensionlessAndBacklash(int8_t dat) {
    float val;

    if ((dat < BACKLASH) && (dat > -BACKLASH)) {
        dat = 0;
    } else {
        dat += (dat > 0) ? (-BACKLASH) : (BACKLASH);
    }
    val = (float) dat / (float) (128 - BACKLASH);
    return val;
}

static uint8_t getsum(void *buf, size_t size) {
    const uint8_t *p = (uint8_t*) buf;
    uint8_t ret = 0;

    for (; size; size--) {
        ret += *p++;
    }
    return ret;
}
