#include "mbed.h"
#include "DualShock.h"

Serial DS_serial(PA_9, PA_10);
Serial pc(SERIAL_TX, SERIAL_RX);

int main() {
    DS_serial.baud(115200);     //通信速度設定
    InitDS(&DS_serial);         //受信データ用変数を初期化する
    DS_serial.attach(&getDSdata, Serial::RxIrq);    //「受信したら割り込みして」の宣言

    while (1) {
        pc.printf("%d\t %d\t\t %d\t%d\r\n",hDS.BUTTON.L2, hDS.BUTTON.UP, hDS.BUTTON.TRIANGLE, hDS.BUTTON.R2);
        pc.printf("%d\t%d %d\t\t%d %d\t%d\r\n",hDS.BUTTON.L1, hDS.BUTTON.LEFT, hDS.BUTTON.RIGHT, hDS.BUTTON.SQUARE, hDS.BUTTON.CIRCLE, hDS.BUTTON.R1);
        pc.printf("\t %d\t  %d/%d\t %d\r\n",hDS.BUTTON.DOWN, hDS.BUTTON.SELECT, hDS.BUTTON.START, hDS.BUTTON.CROSS);
        pc.printf("LX:%.3f,LY:%.3f\tRX:%.3f,RY:%.3f\r\n",hDS.ANALOG.LX, hDS.ANALOG.LY, hDS.ANALOG.RX, hDS.ANALOG.RY);
        pc.printf("\r\n");
        wait_ms(400);
    }
    return 0;
}