/***********************************
*   rgbhlr.h
* 
* 
* @author Kemal Zebari
*
*/

#ifndef RGB_HANDLER_H
#define RGB_HANDLER_H

#include <vector>

namespace rgb_dws {
    typedef int rgbvar;
    
    struct RGB {
        
        RGB();
        RGB(rgbvar r, rgbvar g, rgbvar b);
        RGB(const RGB& c);

        rgbvar red, green, blue;
    };

    // struct for calculations on RGB values (i.e mean, stand. dev., etc)
    struct RGBCalc {

        RGBCalc();
        RGBCalc(double r, double g, double b);
        RGBCalc(const RGBCalc& c);

        double redC, greenC, blueC;

    };
} // END OF NAMESPACE 'rgb_dws'

#endif
