/*
 * PROGRAM RESPONSIBLE FOR open/close door.
 * ^^^^^^^ ^^^^^^^^^^^ ^^^ ^^^^^^^^^^ ^^^^
 *
 * FILE NAME: speed.cpp
 * USAGE: program that control the speed of servo motor.
 */


/*
* including the wanted library files.
*/
#include "mbed.h"
#include "speed.h"
#include "Servo.h"

/*--------------------------*\
 *  defineding the variables*
\*--------------------------*/
float varying_speed;
float speed_now;
int  delta_time;

Ticker motor_timer;/* using ticker class which repeatedly call a function*/
Servo motor_speed(p26); //     Servo PinName (pin)

void motor (float speed, int time) { // void FunctionName (speed between 0-1, time in mS)
// function responsible of increasing or decreasing the speed of the elevator softly
    if (time) {
        varying_speed= (speed - speed_now)/float (time);
        delta_time=time;
        /*---- Print message: shows motor speed at this point ------------------------------------*/
        printf("Motor going to speed %f over %f seconds\n",speed,float(time)/1000);
    } else {
        motor_speed = speed;
        /*---- Print message: shows motor speed at this point ------------------------------------*/
        printf("Motor at speed %f now\n",speed);
        speed_now=speed;
    }
}

void motor_update (void) { // function responsible of checking the speed is within servo rang (0-1)
    if (delta_time) {

        speed_now = speed_now + varying_speed; // event at reverst direction, this formela is removing the minus (all the result is positive)
        /* putting the speed in rang between 0 to 1 */
        if (speed_now>1.0) {
            speed_now =1;
        }
        if (speed_now<0.0) {
            speed_now=0;
        }
        motor_speed=speed_now;
        delta_time--; // decrease the time by 1
    }
}

void motor_start (void) {// a ticker function for the LED doors.
    speed_now = 0.5;
    motor_speed=speed_now; // stop the motor
    delta_time=0;          // at 0S time
    motor_timer.attach(&motor_update,0.001);// repeatedly call "motor_update" function.
}