/*********************************************************
 * state machine assignment - elevator.                  *
 *      a software for two level elevator                *
 *                                                       *
 * Author:   Fatema A.Razaq Mohammed                     *
 * Purpose:  improve the abilty of using state machine   *
 * *******************************************************/

/*
 * THE MAIN FILE OF THIS PROGRAM.
 * ^^^ ^^^^ ^^^^ ^^ ^^^^ ^^^^^^^
 *
 * FILE NAME: main.cpp
 * USAGE: gathering the programs funtcions.   
 */
 
 
 
/* 
 * including all the created library files of the elevator program.   
 */
#include "mbed.h"
#include "main.h"
#include "PIN_DETECT.h"
#include "beeper.h"
#include "LED.h"
#include "speed.h"
#include "event_and_actions.h"


event get_event (void); // a function that has "event" as return type. 
state current_state;    // variable named current_state    
event current_event;    // variable named current_event 

/*---- for testing the program, all the events and states were rewrite to be use in Printf -------------------*/
const char event_lookup[MAX_EVENT][20] ={"B_level_1", "B_level_2", "call_1", "call_2", "NR_top", "NR_bottom", "at_top", "at_bottom", "timeout", "safety"};
const char state_lookup[MAX_STATE][20] ={"top", "waiting_beeper_tp", "waiting_door_tp", "wating_top_sw", "going_down","bottom", "waiting_beeper_bm","waiting_door_bm", "waiting_bottom_sw", "going_up", "waiting_for_safety", "waiting_for_Bfloor"};

/* state machine table (events VS states) */
void (*const state_table [MAX_STATE][MAX_EVENT]) (void) = {
    /*B_level_1          B_level_2           call_1          call_2          NR_top          NR_bottom           at_top          at_bottom           timeout          safety         */
    {move_to_bottom,     door_top,           move_to_bottom, door_top,       ND,             ND,                 motor_stop_tp,  ND,                 ND,              slow_back      },            /*top*/
    {ND,                 ND,                 ND,             ND,             ND,             ND,                 ND,             ND,                 door_top,        ND             },            /*waiting_beeper_tp*/
    {ND,                 ND,                 ND,             ND,             ND,             ND,                 ND,             ND,                 close_top,       ND             },            /*waiting_door_tp*/
    {ND,                 ND,                 ND,             ND,             slow_down_tp,   ND,                 motor_stop_tp,  ND,                 ND,              slow_back      },            /*wating_top_sw*/
    {ND,                 ND,                 ND,             ND,             ND,             slow_down_bm,       ND,             ND,                 ND,              ND             },            /*going_down (when it's hite the near bottom switch)*/
    {door_bottom,        move_to_top,        door_bottom,    move_to_top,    ND,             ND,                 ND,             motor_stop_bm,      ND,              ND             },            /*bottom*/
    {ND,                 ND,                 ND,             ND,             ND,             ND,                 ND,             ND,                 door_bottom,     ND             },            /*waiting_beeper_bm*/
    {ND,                 ND,                 ND,             ND,             ND,             ND,                 ND,             ND,                 close_bottom,    ND             },            /*waiting_door_bm*/
    {ND,                 ND,                 ND,             ND,             ND,             slow_down_bm,       ND,             motor_stop_bm,      ND,              ND             },            /*waiting_bottom_sw*/
    {ND,                 ND,                 ND,             ND,             slow_down_tp,   ND,                 ND,             ND,                 ND,              slow_back      },            /*going_up*/
    {ND,                 ND,                 ND,             ND,             ND,             ND,                 ND,             ND,                 ND,              slow_back      },            /*waiting_for_safety*/
    {ND,                 ND,                 ND,             ND,             ND ,            ND,                 ND,             motor_stop_bm,      ND,              ND             }             /*waiting_for_Bfloor*/
};


int main (void) {

/*-------------------------------------------------------------------*\ 
 *  first calling the ticker and switche depancing created finctions * 
\*-------------------------------------------------------------------*/  
    switches();   /* call switche depancing function */
    bing_start(); /* call the created ticker function of the beeper */
    doors_start();/* call the created ticker function of the doors */ 
    motor_start();/* call the created ticker function of the motor */

current_state = waiting_for_safety;  /* sat the first state to begain with */

/*---- Print message: shows the starting states which program at ------------------------------------*/
         printf("Statrting State: %s\n",state_lookup[current_state]);
         
    motor(0.4,0); /* calling a function to run the motor at slow speed*/

    while (1) { 
        current_event=get_event(); /* changing the event according to what happen next */
/*---- a print message: shows the event' program at ------------------------------------*/
        printf("Event: %s    ",event_lookup[current_event]);         
        state_table[current_state][current_event](); /* changing the state according to the events (depending on the state machine table)*/
/*---- a print message: shows the state' program at ------------------------------------*/
         printf("State: %s\n",state_lookup[current_state]);
   }

} 