/*
 * PROGRAM RESPONSIBLE FOR BEEPING.
 * ^^^^^^^ ^^^^^^^^^^^ ^^^ ^^^^^^^
 *
 * FILE NAME: beeper.cpp
 * USAGE: a simple beep program.
 */



/*
* including the wanted library files.
*/
#include "mbed.h"
#include "beeper.h"
#include "main.h"

AnalogOut beeper(p18); /*set the voltage of an analog output pin*/
Ticker bing_timer; /* using ticker class which repeatedly call a function*/

/*--------------------------*\
 *  defineding the variables*
\*--------------------------*/
const signed short *ptr;
signed short a;
int b;
unsigned short c;
int order;

void bing(void) { // a function that defined the number of elements
    order=23118;
    ptr=ding;
}

void beep (void) { // a function responsible of creating sound

    if (order) {
        /********************************************************
         * this part is converting sined values to unsigned     *
         * so as to make the sound clear                        *
         ********************************************************/
        a=*ptr;
        ptr++;
        b=a;
        c= (unsigned short)b;
        beeper=c;
        if (--order==0) // when the beeping is finish a new event will be called (timeout)
            new_event(timeout);
    }
}

void bing_start (void) { // a ticker function for the beeper.
    beeper=0;
    order=0;
    bing_timer.attach_us(&beep,23); // repeatedly call "beep" function.
}