/*
 * SWITCH DEBOUNCING
 * ^^^^^^ ^^^^^^^^^^
 *
 * FILE NAME: PIN_DETECT.cpp
 * USAGE:  Extends DigitalIn to add mechanical switch deboucing of inputs.
 */


/*
* including the wanted library files.
*/
#include "mbed.h"
#include "main.h"
#include "PIN_DETECT.h"
#include "PinDetect.h"

/********************************************************************************
*********************************************************************************
******* WARNING: to used this file, PinDetect library must be import ************
*******                    into the program                          ************
*********************************************************************************
*********************************************************************************/

PinDetect top_SW (p13);
PinDetect NR_top_SW (p14);
PinDetect bottom_SW (p15);
PinDetect NR_bottom_SW (p16);
PinDetect top_call (p17);
PinDetect bottom_call (p19);
PinDetect goto_top (p20);
PinDetect goto_bottom (p21);
PinDetect safety_button (p22);

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>> functions callbacks follow <<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
void SW_1 (void) { /* top switch pressed*/
    new_event(at_top);
}

void SW_2 (void) { /*near top switch pressed*/
    new_event(NR_top);
}

void SW_3(void) { /*near bottom switch pressed*/
    new_event(NR_bottom);
}

void SW_4 (void) { /*bottom switch pressed*/
    new_event(at_bottom);
}

void SW_5 (void) { /*top call button pressed*/
    new_event(call_2);
    flag_call_2=1;
}

void SW_6 (void) { /*bottom call button pressed*/
    new_event(call_1);
    flag_call_1=1;
}

void SW_7 (void) { /*go to top button*/
    new_event(B_level_2);
}

void SW_8 (void) { /*go to bottom button*/
    new_event(B_level_1);
}

void SW_9 (void) { /*safety switch*/
    new_event(safety);
}

// C function for pin detect

void switches (void) {
// Debouncing >>>>

    // for switch 1 (top switch)
    top_SW.mode( PullUp );
    top_SW.setAssertValue(0);
    top_SW.attach_asserted( &SW_1 );
    top_SW.setSampleFrequency();


    // for switch 2 (near top switch)
    NR_top_SW.mode( PullUp );
    NR_top_SW.setAssertValue(0);
    NR_top_SW.attach_asserted( &SW_2 );
    NR_top_SW.setSampleFrequency();// Defaults to 20ms.


    // for switch 3 (near bottom switch)
    bottom_SW.mode( PullUp );
    bottom_SW.setAssertValue(0);
    bottom_SW.attach_asserted( &SW_3 );
    bottom_SW.setSampleFrequency();// Defaults to 20ms.


    // for switch 4 (bottom switch)
    NR_bottom_SW.mode( PullUp );
    NR_bottom_SW.setAssertValue(0);
    NR_bottom_SW.attach_asserted( &SW_4 );
    NR_bottom_SW.setSampleFrequency();// Defaults to 20ms.


    // for switch 5 (top call switch)
    top_call.mode( PullUp );
    top_call.setAssertValue(0);
    top_call.attach_asserted( &SW_5 );
    top_call.setSampleFrequency();// Defaults to 20ms.


    // for switch 6 (bottom call switch)
    bottom_call.mode( PullUp );
    bottom_call.setAssertValue(0);
    bottom_call.attach_asserted( &SW_6 );
    bottom_call.setSampleFrequency();// Defaults to 20ms.


    // for switch 7 (level select button)
    goto_top.mode( PullUp );
    goto_top.setAssertValue(0);
    goto_top.attach_asserted( &SW_7 );
    goto_top.setSampleFrequency();// Defaults to 20ms.


    // for switch 8 (level select button)
    goto_bottom.mode( PullUp );
    goto_bottom.setAssertValue(0);
    goto_bottom.attach_asserted( &SW_8 );
    goto_bottom.setSampleFrequency();// Defaults to 20ms.


    // for switch 9 (safety switch)
    safety_button.mode( PullUp );
    safety_button.setAssertValue(0);
    safety_button.attach_asserted( &SW_9 );
    safety_button.setSampleFrequency();// Defaults to 20ms.
}


/********************************************************************************
*********************************************************************************
******* for more detail about switch depancing program vist         *************
*******  http://mbed.org/users/AjK/libraries/PinDetect/lkyxpw       *************
*********************************************************************************
*********************************************************************************/