/*
 * ENEVTS AND ACTIONS FUNCTIONS.
 * ^^^^^^ ^^^ ^^^^^^^ ^^^^^^^^^
 *
 * FILE NAME: event_and_actins.cpp
 * USAGE: all the actions and some of the events functions are here.
 */


/*
* including the wanted library files.
*/
#include "mbed.h"
#include "speed.h"
#include "LED.h"
#include "beeper.h"

/*--------------------------*\
 *  defineding the variables*
\*--------------------------*/
int upload;
int loaded;
int flag_call_1=0;
int flag_call_2=0;

event event_queue [11]; // variable named current_state; event type

/*>>>>>>>>>>>>>>>>>>>>>>> function responsible of moving the elevotor to the first floor <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
void move_to_bottom (void) {
    motor (1.0, 2000); /* calling "motor" function to run the motor from 0 to high speed during 2mS */
    current_state = going_down; /* putting this function in "going_up" state. */
}

/*>>>>>>>>>>>>>>>>>>>>>>> function responsible of stopping the motor at the top floor <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
void motor_stop_tp (void) {
    motor (0.5,0); /* calling "motor" function to stop the motor */
    bing (); /* calling "bing" function that start beeping */
    current_state = waiting_beeper_tp; /* putting this function in "waiting_beeper_tp" state. */
}

/*>>>>>>>>>>>>>>>>>>>>>>> function responsible of stopping the motor at the bottom floor <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
void motor_stop_bm (void) {
    motor (0.5,0); /* calling "motor" function to stop the motor*/
    bing (); /* calling "bing" function that start beeping*/
    current_state =waiting_beeper_bm; /* putting this function in "waiting_beeper_bm" state. */
}

/*>>>>>>>>>>> function responsible of slowing down the motor when the elevator is near the top floor <<<<<<<<<<<<<<<*/
void slow_down_tp (void) {
    motor (0.35, 1000); /* calling "motor" function to run the motor from high to slow speed (0.2) during 1mS */
    current_state = wating_top_sw; /* putting this function in "wating_top_sw" state. */
}

/*>>>>>>>>>>> function responsible of slowing down the motor when the elevator is near the bottom floor <<<<<<<<<<<<<<<*/
void slow_down_bm (void) {
    motor (0.6, 1000); /* calling "motor" function to run the motor from high to slow speed (0.8) during 1mS */
    current_state = waiting_bottom_sw;/* putting this function in "waiting_bottom_sw" state. */
}

/*>>>>>>>>>>>>>>>>>>>>>>> function responsible of stopping the motor at the top floor <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
void move_to_top (void) {
    motor (0.0, 2000); /* calling "motor" function to run the motor from 0 to high speed during 2mS */
    current_state = going_up;/* putting this function in "going_up" state. */
}

/*>>>>>>>>>>>>>>>>>>>>>>> function responsible of stopping the motor at the top floor <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
void door_top (void) {
    open_close_doors ( 1 ); /* calling "open_close_doors" function to open the top door; name of the function(selecting floor)*/
    current_state = waiting_door_tp;/* putting this function in "waiting_door_tp" state. */
}

/*>>>>>>>>>>>>>>>>>>>>>>> function responsible of stopping the motor at the top floor <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
void door_bottom (void) {
    open_close_doors ( 0 );/* calling "open_close_doors" function to open the bottom door; name of the function(selecting floor)*/
    current_state = waiting_door_bm;/* putting this function in "waiting_door_bm" state. */
}


/*>>>>>>>>>>>>>>>>>>>>>>> function responsible of stopping the motor at the top floor <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*-----> start the door open close sequence on the led's, when the sequence finishes then a timeout event is generated <-----*/
void close_top (void) {
    current_state = top;/* putting this function in "top" state. */
    /*>>>>>>> flag operation <<<<<<<<<*/
    flag_call_2=0;
    if (flag_call_1) move_to_bottom();
}

    /*>>>>>>>>>>>>>>>>>>>>>>> function responsible of stopping the motor at the top floor <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
    /*-----> start the door open close sequence on the led's, when the sequence finishes then a timeout event is generated <-----*/
    void close_bottom (void) {
        current_state = bottom;/* putting this function in "bottom" state. */
        /*>>>>>>> flag operation <<<<<<<<<*/
        flag_call_1=0;
        if (flag_call_2) move_to_top();
}
        /*>>>>>>>>>>>>>>>>>>>>>>> function responsible of do nothing <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
        void ND (void) {
        }

        /*>>>>>>>>>>>>>>>>>>>>>>> function responsible of getting new event <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
        void new_event (event next_event) {
            event_queue [upload]=next_event;
            upload++;
            if (upload==11)
                upload=0;
        }

        /*>>>>>>>>>>>>>>>>>>>>>>> function responsible of getting event <<<<<<<<<<<<<<<<<<<<<<<<<<<*/
        event get_event (void) {
            do {
                printf("");
            } while (upload==loaded);
            event ev;
            ev =  event_queue [loaded++];
            if (loaded ==11)
                loaded =0;
            return (ev);
        }

        /*>>>>>>>>>> function responsible of running the motor backward when the elevotor hit the safety switch <<<<<<<<<<<*/
        void slow_back (void) {
            motor(0.6,0); /* calling "motor" function to run the motor at slow speed*/
            current_state=waiting_for_Bfloor; /* putting this function in "waiting_for_Bfloor" state. */
            /*---- Print message: shows when this function is called ---------------------------------*/
            printf("slow back running   ");
        }