/*
 * PROGRAM RESPONSIBLE FOR open/close door.
 * ^^^^^^^ ^^^^^^^^^^^ ^^^ ^^^^^^^^^^ ^^^^
 *
 * FILE NAME: LED.cpp
 * USAGE: program that control 16 LED's that indicate the position of the doors.
 */


/*
* including the wanted library files.
*/
#include "mbed.h"
#include "LED.h"
#include "main.h"

/*--------------------------*\
 *  defineding the variables*
\*--------------------------*/
int floor_level;
int LED_order;

DigitalOut latch(p8); //  control a digital output pin..

SPI spi(p5, p6, p7); // SPI bus master; mosi, miso, sclk.
Ticker door_timer; /* using ticker class which repeatedly call a function*/

void open_close_doors ( int f) { // a function that defined the number of elements and selecting a floor
    floor_level=f; // for selecting the wanted floor (0, 1)
    LED_order=28; // max. number of the elements
}

void doors (void) { // a function responsible of turning the LEDs on/off
    if (LED_order) {
        spi.write(door_light[floor_level][--LED_order]); //Write to the SPI Slave; Send the command.
        latch=1;// Deselect the device
        latch=0;// Select the device by seting chip select low
        if (LED_order==0) // when the LED order reach 0, a new event will be called (timeout)
            new_event(timeout);
    }
}

void doors_start (void) {// a ticker function for the LED doors.
    spi.format(16,0);
    latch =0;// Select the device by seting chip select low
    spi.write(0xFFFF); //Write to the SPI Slave; Send (0xFFFF)the command.
    latch=1;// Deselect the device
    latch=0;
    LED_order=0;
    door_timer.attach(&doors,0.2);// repeatedly call "doors" function.
}