#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx

InterruptIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);

Timer t;
bool mode = 0;
float mytime = 1;
float debounce_time = 0.1; 
void press()
{
    //mode = !mode; //press the button for changing the loop
    printf("Timer Started!\r\n");
    t.start();
}
void pressed(){
    t.stop();
    //printf("The time taken was %f seconds.\r\n", t.read());
    mytime = t.read();
    t.reset();
    if (mytime >= 3 )
    {
        pc.printf("Time was %f secs, long mode active \r\n", mytime);
            
    }
    else if (mytime >= debounce_time)
    {
        pc.printf("Time was %f secs short mode active \r\n", mytime);
    }
    else {
        pc.printf("Time was %f and it didn't pass the debounce time\r\n", mytime);
    }
}


int main(){
    mybutton.fall(&press);
    mybutton.rise(&pressed);
    while (1){
        if (mytime >= 3 ){
            pc.printf("long mode \r\n ");
            for (int i=0; i<16; i++) {
                if(i<8) {
                    myled = !myled;
                    wait(1);
                } else {
                    myled = !myled;
                    wait(2);
                }
            }
        }
        else if (mytime >= debounce_time){      
            pc.printf("shortmode \r\n");
                for (int i=0; i<8; i++) {
                    if(i<4) {
                        myled = !myled;
                        wait(1);
                    } else {
                        myled = !myled;
                        wait(2);
                    }
                }
            }
    }
}