/**
* define LogFrame Address.
*/
#define FRAME0  0x01
#define FRAME1  0x02

#include "mbed.h"

/**
* MITSUBA class
*/
class MITSUBA {
public:
  /**
  * variables parsed from CAN data
  */
  double batteryVoltage;    // 0.5V / LSB
  double batteryCurrent;    // 1A / LSB
  double motorCurrentPeak;  // 1A / LSB
  double FETtemp;           // 5deg / LSB
  double rpmMotor;          // 1rpm / LSB
  double duty;              // 0.5% / LSB
  double angle;             // 0.5deg / LSB
  double accelPosition;     // 0.5% / LSB
  double regenePosition;    // 0.5% / LSB

  /**
  * MITSUBA constructor.
  @param _can instance of CAN
  @param freq CAN frequency
  */
  MITSUBA(CAN &_can, int freq);
  /**
  * Fetch and Parse data sent by the MITSUBA Inverter.
  @param val LogFrame Address
  */
  void GetCanData(unsigned char val);

private:
  CAN &can;
  int canfreq;
  void ParseFrame0(unsigned char *data);
  void ParseFrame1(unsigned char *data);
};
