#ifndef PID_CNTRL_H_
#define PID_CNTRL_H_

// PID Controller Class
class PID_Cntrl
{
public:

    PID_Cntrl(float Kp, float Ki, float Kd, float Tf, float Ts, float uMin, float uMax);

    float operator()(float error) {
        return update(error);
    }

    virtual     ~PID_Cntrl();

    void        reset(float initValue);
    float       update(float error);
    
private:

    // controller parameters (member variables)
    float Kp, Ki, Kd, Tf, Tx, Ts, yMin, yMax;
    
        
    // storage for signals (member variables)
    float e_old, y_I, y_Dold;
};

#endif

