/*
    PID-T1 Controller class

                      1           s
      G(s) = Kp + Ki --- + Kd ---------
                      s       T_f*s + p

    Eigther reseting the Nucleo via the black button or save a new software on 
    the Nucleo sets the analog output to zero. Zero is equal to -4 Ampere!!!
    Therefor: NEVER !!! reset or save a new software while the VC is powered on
    (the green button on the VC is glowing green)                      

*/

#include "PID_Cntrl.h"
using namespace std;

PID_Cntrl::PID_Cntrl(float Kp, float Ki, float Kd, float Tf, float Ts, float yMin, float yMax)
{
    // link member variables
    this->Kp = Kp;
    this->Ki = Ki;
    this->Tf = Tf;
    this->Ts = Ts;
    this->yMin = yMin;
    this->yMax = yMax;
    
    reset(0.0f);
}

PID_Cntrl::~PID_Cntrl() {}

void PID_Cntrl::reset(float initValue)
{

    // implement controller reset
    e_old = 0.0;
    y_Dold = 0.0;
    y_I = initValue; 
}

float PID_Cntrl::update(float e)
{

    // controller update function 
    
    // calculate uI
    y_I = y_I + Ki*Ts*e; 
    
    // saturate uI, uMin <= uI <= uMax (anti-windup for the integrator part)
    if(y_I > yMax)
        y_I = yMax;
    else if(y_I < yMin)
        y_I = yMin; 

    // calculate uD
    y_Dold = (1.0f - Ts/Tf)*y_Dold + Kd / Tf * (e-e_old);
    
    float y = Kp * e + y_I + y_Dold;
    
    // update signal storage
    e_old = e; 
    
    
    // calculate u
    // ???
    
    // saturate u, uMin <= u <= uMax
    if(y > yMax)
        y = yMax;
    else if(y < yMin)
        y = yMin; 
    
    // update signal storage
    // ???

    return y;
}

