#include "mbed.h"
#include "uECC.h"
#include "MMA8451Q.h"
#include "SHA256.h"
#include <string> 
#include <stdlib.h>
#include "W5500Interface/EthernetInterface.h"
#include "HTTPClient.h"
using namespace std;


char privateKey[43];
char publicKey[81];

char myDevID[6];

PinName const SDA = PTE25;
PinName const SCL = PTE24;
bool isHashed = false;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int count = 0;
int blockNo = 0;
SHA256 hash;
unsigned int mac_addr[6] = {0x00, 0x08, 0xdc, 0x1c, 0xb8, 0x4a};

char* DEV_ID;

static int RNG(uint8_t *dest, unsigned size) {
  //TODO: Add Random number according to mac addr
  return 1;
}

/*
Generate Keys using uECC, private and public key. secp256k1
*/    
void getKeys(){
  const struct uECC_Curve_t * curve = uECC_secp256k1();
  uint8_t privKey[21];
  
  uint8_t pubKey[40];

  int key_status = uECC_make_key(pubKey, privKey, curve);
  if(key_status)
  {
    for(int i = 0; i < 21; ++i) {
        sprintf(privateKey+2*i,"%02x", privKey[i]);
    }
    for(int j = 0; j < 40; ++j) {
        sprintf(publicKey+2*j,"%02x", pubKey[j]);
    }
  }
  
  wait(1);
}

/*
Send data to the REST API
*/
char* sendData(int block, char* data, char* hash)
{
    char sendIP[100]= "192.168.0.110";
    char str[512];
    char get_msg[1024];
    //data?dev_id=123456&block=1&data=1,2,3,4,5,6,7,8,9,10&hash=123456abcdef...

    sprintf(get_msg, "http://%s:5000/data?dev_id=%s&block=%d&data=%s&hash=%s", sendIP,DEV_ID,block,data,hash);

    HTTPClient http;

    printf("msg : %s\r\n",get_msg);
    int ret = http.get(get_msg, str, sizeof(str));
    if(!ret)
    {
      printf("\r\nPage fetched successfully - read %d characters\r\n", strlen(str));
      printf("Result: %s\r\n", str);
      memset(&myDevID,'\0',6);
      strcat(myDevID,str);
      return myDevID;
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
      return "Error";
    }
}

/*
Function to get the hash of the data
Input- SHA256 Object
Output- char*
*/
char* hashData(SHA256 data)
{
 return (char*)hash.hexString().c_str();   
}

/*
Function to sign the data
Input- char*
Output- char*
*/
char* signData(char* data)
{
    const struct uECC_Curve_t * curve = uECC_secp256k1();
    return (char*)uECC_shared_secret((uint8_t*)publicKey, (uint8_t*)privateKey, (uint8_t*)data, curve);
}
/*
Register the device, public key using REST API
*/
char* registerDevice(char* pubKey)
{
    char sendIP[100]= "192.168.0.110";
    char str[512];
    char get_msg[512];
    sprintf(get_msg, "http://%s:5000/register?PublicKey=%s", sendIP,pubKey);
    //"http://192.168.0.110:5000/register?PublicKey=7834783543874";
    
    HTTPClient http;
    
    printf("msg : %s\r\n",get_msg);
    int ret = http.get(get_msg, str, sizeof(str));
    if(!ret)
    {
      printf("\r\nPage fetched successfully - read %d characters\r\n", strlen(str));
      printf("Result: %s\r\n", str);
      memset(&myDevID,'\0',6);
      strcat(myDevID,str);
      return myDevID;
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
      return "Error";
    }   
}

int main(void)
{
    char data[30];
    memset(data,'\0',strlen(data));
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    uECC_set_rng(&RNG);
    printf("My Keys are\r\n");
    getKeys();
    printf("Public Key %s\r\n", publicKey);
    printf("Private Key %s\r\n", privateKey);
    printf("MMA8451 ID: %d\r\n", acc.getWhoAmI());
    uint8_t myPos = acc.getOrientation();
    uint8_t myOldPos = myPos;
    
    //Ethernet enable
    printf("spi init\r\n");
    SPI spi(D11, D12, D13); // mosi, miso, sclk
    wait(1); // 1 second for stable state
    EthernetInterface eth(&spi, D10, D9);//scs(D10), nRESET(PTA20)
    printf("App Start\r\n");
    wait(1); // 1 second for stable state

    uint8_t mac_addr[6] = {0x22, 0x12, 0x34, 0x1c, 0xb8, 0x4a}; // for example
   
    eth.init((uint8_t *)mac_addr); //Use DHCP 
    eth.connect();
    printf("Initialized, MAC: %s\r\n", eth.getMACAddress());
    printf("Connected, IP: %s, MASK: %s, GW: %s\r\n",
           eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());    
    
    DEV_ID = (char*)registerDevice(publicKey);
    if(DEV_ID == "Error")
    {
        printf("ERROR IN REGISTRATION\r\n");
        while(1);
    }
    while(true)
    {
        myPos = acc.getOrientation();
        if(abs((int)myPos - (int)myOldPos) > 1)
        {
            printf("Count ");
            count++;
            printf("%d\r\n",count);
            char temp[3];
            sprintf(temp,"%d",count);
            strcat(data,temp);
            strcat(data,",");
            myOldPos = myPos;
            isHashed = false;
        }
        if(count % 10 == 0 && count !=0 && isHashed == false)
        {
            blockNo++;
            data[strlen(data)-1] = '\0';
            printf("Data %s\r\n", data);
            hash.append(data);
            hash.finalize();
            printf("hash for block %d ", blockNo);
            printf("%s\r\n", hashData(hash));
            sendData(blockNo, data, hashData(hash));
            hash.reset();
            memset(data,'\0',strlen(data));
            isHashed = true;
        }
        wait(1);
    }
}
        
            