#include "mbed.h"
#include "Hexi_OLED_SSD1351.h"
#include "string.h"

#include "images.h"

DigitalOut led_green(LED_GREEN);
DigitalOut vib(PTB9);

Serial eddy(PTD3, PTD2); // tx rx

// Connect to the oled
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); /* (MOSI,SCLK,POWER,CS,RST,DC) */

bool armed = false;
bool alarm = false;

int main() {
    
    // Buffer to store label text
    char text[20];

    // Use default properties
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);    
    
    // Fill the screen    
    oled.FillScreen(COLOR_BLACK);
    
    const uint8_t *borderImage;
    borderImage = border_bmp;
    oled.DrawImage(borderImage,0,20);
        
    // Set text color to white and left aligned
    textProperties.fontColor = COLOR_WHITE;
    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProperties);   
    
    const uint8_t *armedImage; 
    armedImage = lock_bmp;
    
    const uint8_t *disarmedImage; 
    disarmedImage = unlock_bmp;
    
    const uint8_t *alarmImage; 
    alarmImage = alarm_bmp;

    while (true) {
        time_t seconds = time(NULL); // Get the time in unix format

        const tm *t = localtime (&seconds); // Convert the unix time to actual time
        char* s = "AM"; // The suffix to use for the time of day
        int h = t->tm_hour; // The hours
        if (h > 12){ // If it's entering 24/h time, change it to 12/h and add PM
            s = "PM";
            h = h - 12;    
        }
        // Format the time
        sprintf(text,"%d:%d %s",h, t->tm_min, s);
        // Display the time on screen
        oled.TextBox((uint8_t *)text,2,2, 91, 15); 
        
        if(alarm){
            vib = !vib;
            oled.DrawImage(alarmImage,0,20);
        }else{        
            if(armed){
                oled.DrawImage(armedImage,0,20);
            }else{
                oled.DrawImage(disarmedImage,0,20);
            }
        }
        
        // Flash the green led
        led_green = !led_green;
        
        if(eddy.readable()) {
            char read = eddy.getc();
            
            if(read == '0'){
                armed = false;
                alarm = false;
            }else if (read == '1'){
                armed = true;
                alarm = false;
            }else if (read == '2'){
                alarm = true;
            }
        }
        
        Thread::wait(1000);
    }
}
    
    