#include "mbed.h"
#include "hexidraw.h"

#include "images.h"

DigitalOut led_blue(PTC9);

OLED oled;

int main() {
    oled.begin();
    oled.wake();
    oled.clear(BLACK);
    
    //Draw a background image
    oled.image(0,0,hexi_gradiant_bmp_bmp);
    
    //Draw the olympic rings
    uint16_t rad = 10;
    uint8_t pad = 2;
    uint8_t width = 3;
    oled.circle(OLED_WIDTH/2, OLED_HEIGHT/2, rad, Color565(0,0,0), width);
    
    oled.circle((OLED_WIDTH/2)-((rad*2)+pad), OLED_HEIGHT/2, rad, Color565(0,0,255), width);
    oled.circle((OLED_WIDTH/2)+((rad*2)+pad), OLED_HEIGHT/2, rad, Color565(255,0,0), width);

    oled.circle((OLED_WIDTH/2)-((rad*2)/2), OLED_HEIGHT/2+(rad+pad), rad, Color565(255,255,0), width);
    oled.circle((OLED_WIDTH/2)+((rad*2)/2), OLED_HEIGHT/2+(rad+pad), rad, Color565(0,255,0), width);


    while (true) {
        led_blue = !led_blue;
        Thread::wait(500);
    }
}

