

/* REMAP settings */
//Can be used for transition settings
#define REMAP_HORIZONTAL_INCREMENT ( 0 )
#define REMAP_VERTICAL_INCREMENT   ( 1 << 0 )

#define REMAP_COLUMNS_LEFT_TO_RIGHT ( 0 )
#define REMAP_COLUMNS_RIGHT_TO_LEFT ( 1 << 1 )

//rgb or bgr
#define REMAP_ORDER_ABC ( 0 )
#define REMAP_ORDER_CBA ( 1 << 2 )

#define REMAP_SCAN_UP_TO_DOWN ( 0 )
#define REMAP_SCAN_DOWN_TO_UP ( 1 << 4 )

#define REMAP_COM_SPLIT_ODD_EVEN_DIS ( 0 )
#define REMAP_COM_SPLIT_ODD_EVEN_EN  ( 1 << 5 )

#define REMAP_COLOR_RGB565 ( 1 << 6 )

#define OLED_REMAP_SETTINGS ( REMAP_ORDER_ABC | REMAP_COM_SPLIT_ODD_EVEN_EN | REMAP_COLOR_RGB565 | REMAP_COLUMNS_LEFT_TO_RIGHT | REMAP_SCAN_UP_TO_DOWN | REMAP_HORIZONTAL_INCREMENT )

/* ./REMAP settings */

/* Command Lock */

/**
* set lock command
* the locked OLED driver MCU interface prohibits all commands
* and memory access, except the 0xFD command
*/
#define OLED_CMD_SET_CMD_LOCK ( 0xFD /* << 8 */ )
// unlock OLED driver MCU interface for entering command (default upon reset)
#define OLED_UNLOCK           (0x12)
// lock OLED driver MCU interface for entering command
#define OLED_LOCK             (0x16)
// commands 0xA2, 0xB1, 0xB3, 0xBB, 0xBE, 0xC1 are inaccessible in both lock and unlock state (default upon reset)
#define OLED_ACC_TO_CMD_NO    (0xB0)
// commands 0xA2, 0xB1, 0xB3, 0xBB, 0xBE, 0xC1 are accessible in unlock state
#define OLED_ACC_TO_CMD_YES   (0xB1)

/* ./Command Lock */

// Timing Delays
#define SSD1351_DELAYS_HWFILL       (3)
#define SSD1351_DELAYS_HWLINE       (1)


#define OLED_CMD_SET_COLUMN ( 0x15 )
#define OLED_CMD_SET_ROW    ( 0x75 )

#define OLED_CMD_SET_MUX_RATIO (0xCA)

#define OLED_CMD_SET_REMAP ( 0xA0 )

#define OLED_CMD_SET_OSC_FREQ_AND_CLOCKDIV (0xB3)

#define OLED_CMD_STARTLINE (0xA1)

#define OLED_CMD_WRITERAM       (0x5C)
//#define OLED_CMD_READRAM        (0x5D)
#define OLED_CMD_DISPLAYOFFSET  (0xA2)
//#define OLED_CMD_DISPLAYALLOFF  (0xA4)
//#define OLED_CMD_DISPLAYALLON   (0xA5)
#define OLED_CMD_NORMALDISPLAY  (0xA6)
#define OLED_CMD_INVERTDISPLAY  (0xA7)
//#define OLED_CMD_FUNCTIONSELECT (0xAB)
#define OLED_CMD_DISPLAYOFF     (0xAE)
#define OLED_CMD_DISPLAYON      (0xAF)
#define OLED_CMD_PRECHARGE      (0xB1)
//#define OLED_CMD_DISPLAYENHANCE (0xB2)
#define OLED_CMD_SETVSL         (0xB4)
//#define OLED_CMD_SETGPIO        (0xB5)
#define OLED_CMD_PRECHARGE2     (0xB6)
//#define OLED_CMD_SETGRAY        (0xB8)
//#define OLED_CMD_USELUT         (0xB9)
#define OLED_CMD_PRECHARGELEVEL (0xBB)
#define OLED_CMD_VCOMH          (0xBE)
#define OLED_CMD_CONTRASTABC    (0xC1)
#define OLED_CMD_CONTRASTMASTER (0xC7)
#define OLED_CMD_MUXRATIO       (0xCA)
#define OLED_CMD_COMMANDLOCK    (0xFD)
//#define OLED_CMD_HORIZSCROLL    (0x96)
//#define OLED_CMD_STOPSCROLL     (0x9E)
//#define OLED_CMD_STARTSCROLL    (0x9F)

#define oled_dc_pin PTD15 //Data
#define oled_rst_pin PTE6 //Reset 
#define oled_cs_pin PTB20 //Chip Select
#define oled_sck_pin PTB21 //Serial Clock
#define oled_sdi_pin PTB22 //MOSI

#define oled_power_enable PTC13 //Power enable