
#ifndef _HEXIDRAW_H_
#define _HEXIDRAW_H_

    #include <mbed.h>
    #include <stdarg.h>
    
    #include "oled_info.h"
    
    #define BLACK 0x0000
    #define WHITE 0xffff
    
    #define OLED_WIDTH 96
    #define OLED_HEIGHT 96
    
    #define OLED_BYTES_PER_PIXEL ( 2 )
    
    #define OLED_COL_OFFSET 16
    
    #define OLED_IMAGE_SIZE ( OLED_WIDTH * OLED_HEIGHT * OLED_BYTES_PER_PIXEL )
    #define OLED_BMP_HEADER_BYTE_SIZE (6)
    
    #define OLED_SPI_CHUNK (511)
    
    #define OLED_SKIP_IMAGE_HEADER( imgPtr ) ( (const uint8_t*)(imgPtr) + OLED_BMP_HEADER_BYTE_SIZE )
    
    #define USE_BUFFER 0
        
    /* borrowed from the Adafruit library at:
        https://developer.mbed.org/teams/ELLA-Robotics-Inc/code/Adafruit_GFX_1351/ 
       Since I don't know enough to make my own function :) */
    uint16_t Color565(uint8_t r, uint8_t g, uint8_t b) ;
    
    class OLED {
        public:
            OLED();
            void writeCommand(uint8_t v);
            void writeData(uint8_t v);
            void begin();
            void sleep();
            void wake();
            void pixel(int16_t x, int16_t y, uint16_t color);
            void cursor(int x, int y);
            void rect(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t fillcolor);
            void dim();
            void clear(uint16_t color);
            void circle(uint16_t x, uint16_t y, uint16_t radius, uint16_t color, uint16_t width = 1);
            void image (uint16_t x, uint16_t y, const uint8_t* image);
            void hline(uint16_t x, uint16_t y, uint16_t width, uint16_t color, uint16_t thickness = 1);
            void vline(uint16_t x, uint16_t y, uint16_t height, uint16_t color, uint16_t thickness = 1);
            void draw();
        private:
            SPI _spi;
            DigitalOut _cs, _dc, _reset;
            uint16_t displayBuffer[OLED_WIDTH * OLED_HEIGHT];
            void text(uint16_t x, uint16_t y, const uint8_t* text, const uint8_t* font, uint16_t color = WHITE);
        };

#endif