#include "mbed.h"
#include "HCSR04.h"
#include "Servo.h"

#define PARKING_SPACE_TOTAL 100

//Light Pin Assignment
#define RED_1_PIN D6
#define RED_2_PIN D7
#define GREEN_1_PIN D8
#define GREEN_2_PIN D9

//Piezo Speaker Pin Assignment
#define PIEZO_BUZZER_1_PIN D3
#define PIEZO_BUZZER_2_PIN D11

//Servo Motor Pin Assignment
#define SERVO_MOTOR_1_PIN PTA1
//#define SERVO_MOTOR_2_PIN D10

//Ultrasonic Sensor Pin Assignment
#define ECHO_1_PIN D0
#define TRIGGER_1_PIN D1
#define ECHO_2_PIN D4
#define TRIGGER_2_PIN D5

//Pressure Sensor Pin Assignement
#define PRESSURE_1_PIN A0
#define PRESSURE_2_PIN A1
#define VCC 5.00
#define R_DIV 3230.0

//LCD Pin Assignment

//Setting up the lights as output
DigitalOut RED_LIGHT_1(RED_1_PIN);
DigitalOut RED_LIGHT_2(RED_2_PIN);
DigitalOut GREEN_LIGHT_1(GREEN_1_PIN);
DigitalOut GREEN_LIGHT_2(GREEN_2_PIN);

//Setting up the Ultrasonic Sensors
DigitalOut ECHO_1(ECHO_1_PIN);
DigitalIn TRIGGER_1(TRIGGER_1_PIN);
DigitalOut ECHO_2(ECHO_2_PIN);
DigitalIn TRIGGER_2(TRIGGER_2_PIN);

//Setting up the Servo Motors
//DigitalOut SERVO_1(SERVO_MOTOR_1_PIN);
//DigitalOut SERVO_2(SERVO_MOTOR_2_PIN);

//Setting up Piezo Speakers
DigitalOut PIEZO_1(PIEZO_BUZZER_1_PIN);
DigitalOut PIEZO_2(PIEZO_BUZZER_2_PIN);

//Setting up the Pressure Sensors
AnalogIn PRESSURE_1 (PRESSURE_1_PIN);
AnalogIn PRESSURE_2 (PRESSURE_2_PIN);

int main()
{
    /*
    //Car counting variables
    int8_t Car_In = 0;
    int8_t Car_Out = 0;

    //Setting the red lights to 1
    RED_LIGHT_1 = 1;
    RED_LIGHT_2 = 1;

    //Setting the green lights to 0
    GREEN_LIGHT_1 = 0;
    GREEN_LIGHT_2 = 0;

    //Ultrasonic Sensor Stuff
    //If the value fetched from here is less than a certain value
    //Than we know there is an object close to the gate else we
    //don't change anything
    HCSR04 Ultrasonic_1(TRIGGER_1_PIN,ECHO_1_PIN);
    HCSR04 Ultrasonic_2(TRIGGER_2_PIN,ECHO_2_PIN);
    bool isObjectClose_1 = false;
    bool isObjectClose_2 = false;
    uint8_t Distance_1 = 0;
    uint8_t Distance_2 = 0;

    //Pressure Sensor Stuff
    //If the value fetched from here is greater than a certain value
    //than we know it is a car else we don't change anything
    int Pressure_Sensor_1 = 0;
    float fsrR_1;
    float fsrV_1;
    float fsrG_1;
    float force_1;
    int Pressure_Sensor_2 = 0;
    float fsrR_2;
    float fsrV_2;
    float fsrG_2;
    float force_2;
    bool isCar_1 = false;
    bool isCar_2 = false;
*/
    //Servo Motor Stuff
    Servo entranceGate(PTA1);
    //Servo exitGate(SERVO_MOTOR_2_PIN);



    while(1) {
        
        for(float p=0; p<1.0; p += 0.1) 
        {
            entranceGate = p;
            wait(0.2);
        }
    }
}