/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "ESP8266.h"
#include "math.h"

Serial pc(USBTX,USBRX);
DigitalOut rled(LED1);

//wifi UART port and baud rate
ESP8266 wifi(PTC17, PTC16, 115200);    // Class Variable Pin dexlaration for WIFI

//buffers for wifi library
char snd[255],resp[9000];
char http_cmd[300], comm[300];
char url_response[9000];

int timeout = 5000; //timeout for wifi commands

//SSID and password for connection 
#define SSID "Mahutin-2.4"     
#define PASS "12220517"  

//Remote IP
#define IP "184.106.153.149"          // IP for thingspeak server. Remains same for al codes using thingspeak
//Public and private keys for phant
char* Update_Key = "JL9J9L60TE2VXV4K"; 
char* Read_Key = "GTLNT8B1ERTG0SUQ";            

//Wifi init function. Sets the module to connect to wifi accesspoint with ssid and password mentioned above
void wifi_initialize(void){
    
    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.reset();
    
    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.rcvReply(resp, 5000))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response");
    
    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");
    
    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);   
    else
        pc.printf("No response while connecting to network \r\n");
        
    pc.printf("******** Getting IP and MAC of module ********\r\n");
    wifi.GetIP(resp);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while getting IP \r\n");
    
    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();          
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);    
    
    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();             
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
}




int main()
{
    
    wifi_initialize();   // Calls function defined above to initialize the wifi module
    while (true) {
        
        
    }
}
