
#include "SDFileSystem.h"
#include <mbed.h>
#include <string>
#include <list>
#include "wave_player.h"

#include <mpr121.h>
#include "board.h"
#include "uLCD_4DGL.h"


uLCD_4DGL uLCD(p28,p27,p29); 


AnalogOut DACout(p18);

PwmOut PWMout(p22);

wave_player waver(&DACout,&PWMout);  

Timer t;

int currentTile = -1;
int previousTile = -2;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p21);

// Setup the i2c bus on pins 28 and 27
I2C i2c(p9, p10);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
DigitalIn pb1(p19);

void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    if (value != 0 ) { 
        i=0;
        for (i=0; i<12; i++) {
            if (((value>>i)&0x01)==1) key_code=i+1;
            }
        if (currentTile != key_code-1) {
            previousTile = currentTile;
            currentTile = key_code - 1;
            led4=key_code & 0x01; 
            led3=(key_code>>1) & 0x01;
            led2=(key_code>>2) & 0x01;
            led1=(key_code>>3) & 0x01;
        }
    }
}
SDFileSystem sd(p5, p6, p7, p8, "sd"); 
int main() {
    pb1.mode(PullUp);
    t.start();
    uLCD.media_init();
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    
    FILE *wave_file;
    //setup PWM hardware for a Class D style audio output
    PWMout.period(1.0/400000.0);
    
    wave_file=fopen("/sd/wg2.wav","r");
    waver.play(wave_file);
    
    fclose(wave_file);
   
    wait(2);
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    uLCD.cls();
    uLCD.locate(1,4);
    uLCD.printf("Press button to");
    uLCD.locate(7,5);
    uLCD.printf("Start");
        while(pb1) {
        }
    uLCD.cls();
    uLCD.locate(0,0);
    uLCD.printf("You have 60 seconds\n"); //Default Green on black text
    uLCD.text_width(4); //4X size text
    uLCD.text_height(4);
    uLCD.color(RED);
    for (int i=60; i>=58; --i) {
        uLCD.locate(1,2);
        uLCD.printf("%2D",i);
        wait(.5);
    }
    while(1) {
           Board  board = Board(t.read());
        t.reset();
        t.start();
        int oldCurrentTile = -1;
        int oldPreviousTile = -2;
        
        while (t.read()<60) {
            if(!pb1) 
                board.reshuffleBoard();
            if( oldCurrentTile != currentTile && previousTile != oldPreviousTile) {
                
                board.chooseTiles(previousTile, currentTile);
                oldCurrentTile = currentTile;oldPreviousTile = previousTile;
            }
        }
        uLCD.media_init();
        uLCD.set_sector_address(0x0000, 0x0041);
        uLCD.display_image(0,0);
        uLCD.text_width(1); //4X size text
        uLCD.text_height(1);
        uLCD.locate(4,0);
        uLCD.color(RED);
        uLCD.textbackground_color(0xFFC966);
        uLCD.printf("Score : %i",board.getScore());
        wave_file=fopen("/sd/human_error.wav","r");
        waver.play(wave_file);
        
        fclose(wave_file);
        uLCD.cls();
        uLCD.locate(2,4);
        uLCD.printf("Press button to");
        uLCD.locate(7,5);
        uLCD.printf("continue");
        while(pb1) {
        }
    }
}