#include "mbed.h"

#include "tile.h"
#include "uLCD_4DGL.h"
int find(int arr[], int len, int seek)
{
    for (int i = 0; i < len; ++i)
    {
        if (arr[i] == seek) return i;
    }
    return -1;
}

extern uLCD_4DGL uLCD;

int colors[] = {GREEN, BLUE, RED, WHITE};
Tile::Tile() : x1(0), y1(0), x2(0), y2(0),empty(true) {}
Tile::Tile(int x1, int y1, int x2, int y2, bool empty) : x1(x1), y1(y1), x2(x2), y2(y2),empty(empty) {}

void Tile::draw(void) { 
    uLCD.filled_rectangle(x1+1, y1+1, x2-1, y2-1, (empty ? BLACK : tileColor));
}

bool Tile::isEmpty() {
    return empty;
}

void Tile::setColor(int idx) { 
    tileColor = colors[idx];
}

void Tile::setEmpty(bool empty) {
    this->empty = empty;
}

int Tile::getUp(int tileNumber) {
    return (1+tileNumber % 4 == 0 ? -1 : 1+tileNumber);
}

int Tile::getColor() {
    
    return  find(colors, 4, tileColor);
    
}

void Tile::selectMatchedTiles(void) { 
    
     uLCD.filled_rectangle((x1+x2)/2+5, y1, (x1+x2)/2-5, y2, BLACK);
     uLCD.filled_rectangle(x1, (y1+y2)/2+5, x2, (y1+y2)/2-5, BLACK);
     
}

void Tile::selectTile(void) { 
     uLCD.filled_circle((x1+x2)/2, (y1+y2)/2, 10, BLACK);
    
     
}

void Tile::deselectTile(void) { 
     uLCD.filled_circle((x1+x2)/2, (y1+y2)/2, 11, tileColor);
}

bool Tile::isNeighbour(int tile1, int tile2) {
    
    switch(tile1) {
        case 0 : return tile2 == 1 || tile2 == 4;
        case 1 : return tile2 == 0 ||tile2 == 2 || tile2 == 5;
        case 2 : return tile2 == 1 ||tile2 == 3 || tile2 == 6;
        case 3 : return tile2 == 7 || tile2 == 2;
        case 4 :return tile2 == 0 ||tile2 == 8 || tile2 == 5;
        case 5 : return tile2 == 1 ||tile2 == 4 || tile2 == 6 || tile2 == 9;
        case 6 : return tile2 == 7 || tile2 == 2|| tile2 == 5|| tile2 == 10;
        case 7 : return tile2 == 11 ||tile2 == 3 || tile2 == 6;
        case 8 : return tile2 == 4 || tile2 == 9;
        case 9 : return tile2 == 8|| tile2 == 5|| tile2 == 10;
        case 10 :  return tile2 == 11 ||tile2 == 9 || tile2 == 6;
        case 11: return tile2 == 10 ||tile2 == 7 ;    
}

  
   
    if(tile1 == getUp(tile2))
        return true;
    if(tile2 == getUp(tile1))
        return true;
    if(tile2 == tile1 + 4)
        return true;
    if(tile1 == tile2 + 4)
        return true;
    return false;
}