#ifndef BOARD_H__
#define BOARD_H__

#define SELECT_SOUND "/sd/click_x.wav"
#define ERROR_SOUND "/sd/error.wav"
#define DELETE_SOUND "/sd/blip.wav"
#include "tile.h"
#include <vector>
class Board{
    
    private:
    
        Tile tiles[12];
        
        int score;
    
        float seed;
        
    public:
        
        
        Board(float seed);
        
        void fillBoard();
    
        void tilesFallDown();

        void chooseTiles(int previousTile, int currentTile);

        void swapTiles(int tile1, int tile2);

        void removeMatches(int tile1, int tile2);
        
        std::vector<int> findMatches();

        void deleteTiles(std::vector<int> tileMatches);
        
        void drawBoard();
        
        bool threeInARow(int i, int j, int k);
        
        void soundEffect(char * effectName) ;
        
        int getScore();
        
        bool movesLeft();
        
        void reshuffleBoard();
};

#endif