#include "board.h"
#include "stdio.h"      
#include "stdlib.h"   
#include "time.h"
#include <vector>
#include <algorithm>
#include "mbed.h"
#include "wave_player.h"



#include "uLCD_4DGL.h"

extern wave_player waver;  

extern uLCD_4DGL uLCD;

using namespace std;

int tx1[] = {0,42,85,0,42,85,0,42,85,0,42,85};
int ty1[] = {0,0,0,32,32,32,64,64,64,96,96,96};
int tx2[] = {42,85,128,42,85,128,42,85,128,42,85,128};
int ty2[] = {32,32,32,64,64,64,96,96,96,128,128,128};

int indexConverter(int i){
    switch(i) {
        case 0 : return 10;
        case 1 : return 7;
        case 2 : return 4;
        case 3 : return 1;
        case 4 : return 11;
        case 5 : return 8;
        case 6 : return 5;
        case 7 : return 2;
        case 8 : return 12;
        case 9 : return 9;
        case 10 : return 6;
        case 11: return 3;    
}
}
  
int x1[12]; 
int y1[12];
int x2[12];
int y2[12];

void temp() {
    for ( int i = 0; i < 12; i++ ) {
        x1[i] = tx1[indexConverter(i)-1];
    }
    for ( int i = 0; i < 12; i++ ) {
        x2[i] = tx2[indexConverter(i)-1];
    }
    for ( int i = 0; i < 12; i++ ) {
        y1[i] = ty1[indexConverter(i)-1];
    }
    for ( int i = 0; i < 12; i++ ) {
        y2[i] = ty2[indexConverter(i)-1];
    }
}

Board::Board(float sd) {
    score = 0;
    seed = sd;
    temp();
    for ( int i = 0; i < 12; i++ ) {
        tiles[i] = Tile(x1[i],y1[i],x2[i],y2[i], true); 
   }
   fillBoard();
   drawBoard();
   
   srand (seed);
   
}

int lx[] = {0,42,85,128};
int ly[] = {0,32,64,96,128};
  
void Board::drawBoard() {
    for ( int i = 0; i < 12; i++ ) {
        tiles[i].draw();
    }
    for ( int i = 0; i < 4; i++ ) {
       uLCD.line(lx[i], 0,lx[i], 128, BLACK);
    }
    for ( int i = 0; i < 5; i++ ) {
       uLCD.line(0,ly[i],128,ly[i], BLACK);
    }
}
bool stop = true;
void Board::fillBoard() {
    stop = true;
    
    
    for ( int i = 0; i < 12; i++ ) {
        if (tiles[i].isEmpty()) {
            tiles[i].setColor(rand() % 4);
            tiles[i].setEmpty(false);
            stop = false;
        } 
    }
    if (!stop) {
    vector<int> boardMatches = findMatches();
    
    
        while(!boardMatches.empty()){
                drawBoard();
                deleteTiles(boardMatches);
                drawBoard();
                tilesFallDown();
                drawBoard();
                boardMatches = findMatches();
        }

        fillBoard();
    }
    
    
}
    
void Board::tilesFallDown() {
    
    int lowestEmptySpot = -1;
    int lowestFilledSpot = -1;
    
    for ( int i = 0; i < 12; i = i+4 ) {
        lowestEmptySpot = -1;
        lowestFilledSpot = -1;
        for ( int j = i; j < i+4; j++ ) {
            if(lowestEmptySpot == -1 && tiles[j].isEmpty() )//&&)// lowestFilledSpot < lowestEmptySpot)
                lowestEmptySpot = j;
        }
        for ( int j = lowestEmptySpot+1; j < i+4; j++ ) {
            if(lowestFilledSpot == -1 && !tiles[j].isEmpty() )//&&)// lowestFilledSpot < lowestEmptySpot)
                lowestFilledSpot = j;
        }
           
        if(!(lowestEmptySpot == -1) && !(lowestFilledSpot == -1) && lowestFilledSpot > lowestEmptySpot)
           while(lowestFilledSpot < i+4) {
                tiles[lowestEmptySpot].setColor(tiles[lowestFilledSpot].getColor());
                tiles[lowestEmptySpot].setEmpty(false);
                tiles[lowestFilledSpot].setEmpty(true);
                lowestEmptySpot++;
                lowestFilledSpot++;
            }
        
    }
}

void Board::chooseTiles(int previousTile, int currentTile) {
   
    tiles[currentTile].selectTile();
   
    soundEffect(SELECT_SOUND);    
    
    if(tiles[currentTile].isNeighbour(currentTile, previousTile)) {
       
        swapTiles(previousTile, currentTile);
        
        vector<int> boardMatches = findMatches();
        if(boardMatches.empty()){
            swapTiles(currentTile, previousTile);
            drawBoard();
            soundEffect(ERROR_SOUND);
        } else {
            while(!boardMatches.empty()){
                drawBoard();
                deleteTiles(boardMatches);
                drawBoard();
                tilesFallDown();
                drawBoard();
                boardMatches = findMatches();
            }
            fillBoard();
            drawBoard();
        }
        
    } else {
        tiles[previousTile].deselectTile();
    }
    tiles[currentTile].selectTile();
  
}

void Board::swapTiles(int tile1, int tile2) {
     
    int tile1Color = tiles[tile1].getColor();
    int tile2Color = tiles[tile2].getColor();
   
    tiles[tile1].setColor(tile2Color); 
    tiles[tile2].setColor(tile1Color);
    
}

void Board::removeMatches(int tile1, int tile2) {
   
   
    vector<int> boardMatches = findMatches();
    if(boardMatches.empty()){
        swapTiles(tile1, tile2);
        drawBoard();
    } else {
        deleteTiles(boardMatches);
        drawBoard();
        tilesFallDown();
        drawBoard();
        wait(5);
        fillBoard();

    }
    
   
}



void Board::deleteTiles(vector<int> tileMatches) {
    
    while (!tileMatches.empty()) {
        tiles[tileMatches.back()].selectMatchedTiles();
        tiles[tileMatches.back()].setEmpty(true);
        tileMatches.pop_back();
        score++;
    }
    soundEffect(DELETE_SOUND);
}
  
vector<int> Board::findMatches() {
    
   
    vector<int> matches;
    
    for(int i = 0 ; i < 4 ; i ++) {
        if(threeInARow(i,i+4,i+8)) {
            matches.push_back(i);
            matches.push_back(i+4);
            matches.push_back(i+8);
        }
    }
    for(int i = 0; i < 12; i = i + 4) {
        if(threeInARow(i,i+1,i+2)) {
            matches.push_back(i);
            matches.push_back(i+1);
            matches.push_back(i+2);
        }
        i++;
        if(threeInARow(i,i+1,i+2)) {
            matches.push_back(i);
            matches.push_back(i+1);
            matches.push_back(i+2);
        }
        i--;
    }
    sort( matches.begin(), matches.end() );
    matches.erase( unique( matches.begin(), matches.end() ), matches.end());
   
    return matches;
    
}

bool Board::threeInARow(int i, int j, int k) {
    return !tiles[i].isEmpty()&&!tiles[j].isEmpty()&&!tiles[k].isEmpty()&&tiles[i].getColor() == tiles[j].getColor() && tiles[j].getColor() == tiles[k].getColor();
}

void Board::soundEffect(char * effectName) {
    FILE *wave_file;
    wave_file=fopen(effectName,"r");
    waver.play(wave_file);
    fclose(wave_file);
} 

int Board::getScore() {
    return 500*score;
}

bool Board::movesLeft(){
    vector<int> matches;
    for (int i = 0; i<12;i++) {
        if((i+1)%4 != 0) {
            swapTiles(i,i+1);
            matches = findMatches();
            swapTiles(i,i+1);
            if(!matches.empty())
                return true;
        }
        if((i+4)%4 > 12) {
            swapTiles(i,i+4);
            matches = findMatches();
            swapTiles(i,i+4);
            if(!matches.empty())
                return true;
        }
    }
    return false;
}
    
void Board::reshuffleBoard() {
    for (int i = 0; i<12;i++)
        tiles[i].setEmpty(true);
    fillBoard();
    drawBoard();
}