/**
* Copyright (c)2010 ARM Ltd.
* Released under the MIT License: http://mbed.org/license/mit
*/
#include "mbed.h"
#include "SerialRPCInterface.h"
#include "uLCD_4DGL.h"
#include "Motor.h"

Motor mr(p23, p19, p20); // pwm, fwd, rev
Motor ml(p24, p21, p22); // pwm, fwd, rev 
Serial pc(USBTX, USBRX);
InterruptIn state(p11);
float r;
float l;
RPCVariable<float> rpc_l(&l, "l");
RPCVariable<float> rpc_r(&r, "r");

using namespace mbed;

//Create the interface on the USB Serial Port
SerialRPCInterface RPC(p9, p10);

void stop(){
    r = 0;
    l = 0;
}

int main() {
    r = 0;
    l = 0;
    
    state.fall(&stop);
    
    while(1) {
        mr.speed(r);
        ml.speed(l);
        pc.printf("Left:%f   Right:%f\n\r", l, r);

    }
}
