#include "mbed.h"

// A class for flip()-ing a DigitalOut 
class Flipper {
public:
    Flipper(PinName pin) : _pin(pin) {
        _pin = 0;
    }
    void flip() {
        _pin = !_pin;
    }
private:
    DigitalOut _pin;
};

DigitalOut led1(LED1);
DigitalOut led3(LED3);

Flipper f(LED2);
Ticker t;

int main() {
    t.attach_us(&f, &Flipper::flip, 25); // the address of the object, member function, and interval
                                            // 25 us = 40kHz
    led3 = 1;

    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        led1 = !led1;
        wait(0.2);
    }
}