#include "mbed.h"
#include "ntshell.h"
#include "ntlibc.h"
#include "VT100CtrlCode.h"

#define CPUID_ADDR (0xe000ed00)
typedef struct
{
  uint32_t Revision:4;
  uint32_t Partno:12;
  uint32_t Constant:4;
  uint32_t Variant:4;
  uint32_t Implementer:8;
} CPUID;

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut gpio(LED1);

ntshell_t ntshell;

static int func_read(char *buf, int cnt, void *extobj)
{
    for (int i = 0; i < cnt; i++)
    {
        buf[i] = pc.getc();
    }


    return cnt;
}

static int func_write(const char *buf, int cnt, void *extobj)
{
    for (int i = 0; i < cnt; i++)
    {
        pc.putc(buf[i]);
    }

    return cnt;
}

static int func_callback(const char *text, void *extobj)
{
    if (ntlibc_strncmp(text, "LED", 3) == 0)
    {
        gpio = !gpio;
    }

    return 0;
}

int main() {
    pc.baud(115200);
    
    const char *Mark = Foreground256(62) Background256(225) \
                       "\r\n"\
                       " _   _ _   _  ____ _     _____ ___        _     ___  ____ _____ ____  ___  \r\n" \
                       "| \\ | | | | |/ ___| |   | ____/ _ \\      | |   / _ \\| ___|___ /|  _ \\( _ ) \r\n" \
                       "|  \\| | | | | |   | |   |  _|| | | |_____| |  | | | |___ \\ |_ \\| |_) / _ \\ \r\n" \
                       "| |\\  | |_| | |___| |___| |__| |_| |_____| |__| |_| |___) |__) |  _ < (_) |\r\n" \
                       "|_| \\_|\\___/ \\____|_____|_____\\___/      |_____\\___/|____/____/|_| \\_\\___/ "
                       ResetAll
                       "\r\n";

    pc.printf(Mark);
    pc.printf("\r\n");    
    
    uint32_t regValue = *((uint32_t *)CPUID_ADDR);
    volatile CPUID cpuid = *((CPUID *)&regValue);
    pc.printf("CPU Information\r\n");
    pc.printf("Implementer : 0x%02x\r\n", cpuid.Implementer);
    pc.printf("Variant     : 0x%1x\r\n", cpuid.Variant);
    pc.printf("Constant    : 0x%1x\r\n", cpuid.Constant);
    pc.printf("Partno      : 0x%3x\r\n", cpuid.Partno);
    pc.printf("Revision    : r%dp%d\r\n", (cpuid.Revision & 0x3 >> 2), (cpuid.Revision & 0x3));
    pc.printf("SysClock    : %d\r\n", SystemCoreClock);
    pc.printf("\r\n");

    pc.printf("Type <" Foreground256(193) Background256(1) "LED" ResetAll "> to toggle led");
    pc.printf("\r\n");
    ntshell_init(&ntshell, func_read, func_write, func_callback, 0);
    ntshell_set_prompt(&ntshell, "NUCLEO>");
    ntshell_execute(&ntshell);

    while (1);
}