// Mbed program to test LPD8806-based RGB LED Strips
// (c) 2011 Jelmer Tiete
// This library is ported from the Arduino implementation of Adafruit Industries
// found at: http://github.com/adafruit/LPD8806
// and their strips: http://www.adafruit.com/products/306
// Released under the MIT License: http://mbed.org/license/mit
//
// standard connected to 1st hardware SPI
// LPD8806  <> MBED
// DATA     -> P5
// CLOCK    -> p7
/*****************************************************************************/

#include "LPD8806.h"

LPD8806 strip = LPD8806(64);

int t[64] = {56,
             57,
             58,
             59,
             60,
             61,
             62,
             63,
             55,
             54,
             53,
             52,
             51,
             50,
             49,
             48,
             40,
             41,
             42,
             43,
             44,
             45,
             46,
             47,
             39,
             38,
             37,
             36,
             35,
             34,
             33,
             32,
             24,
             25,
             26,
             27,
             28,
             29,
             30,
             31,
             23,
             22,
             21,
             20,
             19,
             18,
             17,
             16,
             8,
             9,
             10,
             11,
             12,
             13,
             14,
             15,
             7,
             6,
             5,
             4,
             3,
             2,
             1,
             0};

int r[64] = {56, // 0
             55, // 1
             40, // 2
             39, // 3
             24, // 4
             23, // 5
             8,  // 6
             7,  // 7
             6,  // 8
             9,  // 9
             22, // 10
             25, // 11
             38, // 12
             41, // 13
             54, // 14
             57, // 15
             58, // 16
             53, // 17
             42, // 18
             37, // 19
             26, // 20
             21, // 21
             10, // 22
             5,  // 23
             4,  // 24
             11, // 25
             20, // 26
             27, // 27
             36, // 28
             43, // 29
             52, // 30
             59, // 31
             60, // 32
             51, // 33
             44, // 34
             35, // 35
             28, // 36
             19, // 37
             12, // 38
             3,  // 39
             2,  // 40
             13, // 41
             18, // 42
             29, // 43
             34, // 44
             45, // 45
             50, // 46
             61, // 47
             62, // 48
             49, // 49
             46, // 50
             33, // 51
             30, // 52
             17, // 53
             14, // 54
             1,  // 55
             0,  // 56
             15, // 57
             16, // 58
             31, // 59
             32, // 60
             47, // 61
             48, // 62
             63, // 63
             };

void update(uint32_t * cap) {
    int i;
    
    for (i = 0; i < 64; i++) {
        strip.setPixelColor(t[i], cap[i]);
    }
}

// Chase a dot down the strip
// good for testing purposes
void colorChase(uint32_t c, uint8_t delay) {
    int i;

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, 0);  // turn all pixels off
    }

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, c);
        if (i == 0) {
            strip.setPixelColor(strip.numPixels()-1, 0);
        } else {
            strip.setPixelColor(i-1, 0);
        }
        strip.show();
        wait_ms(delay);
    }
}

void colorChaseT(uint32_t c, uint8_t delay) {
    int i;

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(t[i], 0);  // turn all pixels off
    }

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(t[i], c);
        if (i == 0) {
            strip.setPixelColor(t[strip.numPixels()-1], 0);
        } else {
            strip.setPixelColor(t[i-1], 0);
        }
        strip.show();
        wait_ms(delay);
    }
}

// fill the dots one after the other with said color
// good for testing purposes
void colorWipe(uint32_t c, uint8_t delay) {
    int i;

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, c);
        strip.show();
        wait_ms(delay);
    }
}

//Input a value 0 to 384 to get a color value.
//The colours are a transition r - g -b - back to r

uint32_t Wheel(uint16_t WheelPos) {
    uint8_t b=0;
    uint8_t g=0;
    uint8_t r = 0;
    switch (WheelPos / 128) {
        case 0:
            r = 127 - WheelPos % 128;   //Red down
            g = WheelPos % 128;      // Green up
            b = 0;                  //blue off
            break;
        case 1:
            g = 127 - WheelPos % 128;  //green down
            b = WheelPos % 128;      //blue up
            r = 0;                  //red off
            break;
        case 2:
            b = 127 - WheelPos % 128;  //blue down
            r = WheelPos % 128;      //red up
            g = 0;                  //green off
            break;
    }
    return(strip.Color(r,g,b));
}

void rainbow(uint8_t delay) {
    int i, j;

    for (j=0; j < 384; j++) {     // 3 cycles of all 384 colors in the wheel
        for (i=0; i < strip.numPixels(); i++) {
            strip.setPixelColor(i, Wheel( (i + j) % 384));
        }
        strip.show();   // write all the pixels out
        wait_ms(delay);
    }
}

// Slightly different, this one makes the rainbow wheel equally distributed
// along the chain
void rainbowCycle(uint8_t delay) {
    uint16_t i, j;

    for (j=0; j < 384 * 5; j++) {     // 5 cycles of all 384 colors in the wheel
        for (i=0; i < strip.numPixels(); i++) {
            // tricky math! we use each pixel as a fraction of the full 384-color wheel
            // (thats the i / strip.numPixels() part)
            // Then add in j which makes the colors go around per pixel
            // the % 384 is to make the wheel cycle around
            strip.setPixelColor(i, Wheel( ((i * 384 / strip.numPixels()) + j) % 384) );
        }
        strip.show();   // write all the pixels out
        wait_ms(delay);
    }
}

// "Larson scanner" = Cylon/KITT bouncing light effect
void scanner(uint8_t r, uint8_t g, uint8_t b, uint8_t delay) {
    int i, j, pos, dir;

    pos = 0;
    dir = 1;

    for (i=0; i<((strip.numPixels()-1) * 8); i++) {
        // Draw 5 pixels centered on pos.  setPixelColor() will clip
        // any pixels off the ends of the strip, no worries there.
        // we'll make the colors dimmer at the edges for a nice pulse
        // look
        strip.setPixelColor(pos - 2, strip.Color(r/4, g/4, b/4));
        strip.setPixelColor(pos - 1, strip.Color(r/2, g/2, b/2));
        strip.setPixelColor(pos, strip.Color(r, g, b));
        strip.setPixelColor(pos + 1, strip.Color(r/2, g/2, b/2));
        strip.setPixelColor(pos + 2, strip.Color(r/4, g/4, b/4));

        strip.show();
        wait_ms(delay);
        // If we wanted to be sneaky we could erase just the tail end
        // pixel, but it's much easier just to erase the whole thing
        // and draw a new one next time.
        for (j=-2; j<= 2; j++)
            strip.setPixelColor(pos+j, strip.Color(0,0,0));
        // Bounce off ends of strip
        pos += dir;
        if (pos < 0) {
            pos = 1;
            dir = -dir;
        } else if (pos >= strip.numPixels()) {
            pos = strip.numPixels() - 2;
            dir = -dir;
        }
    }
}

void shield(int delay) {
    
    uint32_t PR = strip.Color(255, 0, 0);
    uint32_t PB = strip.Color(9, 39, 255);
    uint32_t NA = strip.Color(0, 0, 0);

    uint32_t shield[64] = {PR, PR, PR, PR, PR, PR, PR, PR,
                       PR, NA, PR, NA, NA, PR, NA, PR,
                       PR, PR, PR, PR, PR, PR, PR, PR,
                       PR, NA, NA, PB, PB, NA, NA, PR,
                       PR, NA, PB, PB, PB, PB, NA, PR,
                       PR, PB, PB, NA, NA, PB, PB, PR,
                       NA, PR, NA, NA, NA, NA, PR, NA,
                       NA, NA, PR, PR, PR, PR, NA, NA};
                       
    update(shield);
    strip.show();
    wait_ms(delay);                       
     /*                  
     uint32_t shield2[64] = {NA, NA, PR, PR, PR, PR, PR, PR,
                             NA, PR, PB, NA, NA, PR, NA, PR,
                             PR, NA, PB, PB, NA, PR, PR, PR,
                             PR, NA, NA, PB, PB, PR, NA, PR,
                             PR, NA, NA, PB, PB, PR, NA, PR,
                             PR, NA, PB, PB, NA, PR, PR, PR,
                             NA, PR, PB, NA, NA, PR, NA, PR,
                             NA, NA, PR, PR, PR, PR, PR, PR};
    for (i = 0; i < 10; i++) {
        update2(shield);
        strip.show();
        wait_ms(1500);
        update2(shield2);
        strip.show();
        wait_ms(1500);
    }
    */
}

void year(int delay) {
    uint32_t pr = strip.Color(255, 0, 0);
    uint32_t pb = strip.Color(9, 39, 255);

    uint32_t shape[64] = {pb, pb, pb, pb, pr, pb, pb, pb,
                          pb, pb, pb, pr, pb, pb, pb, pb,
                          pb, pb, pr, pb, pb, pr, pr, pb,
                          pb, pr, pb, pb, pb, pb, pb, pr,
                          pr, pb, pb, pr, pr, pb, pb, pr,
                          pb, pb, pr, pb, pb, pr, pr, pb,
                          pb, pb, pb, pr, pb, pb, pb, pb,
                          pb, pb, pb, pb, pr, pb, pb, pb};  
     
    update(shape);
    strip.show();
    wait_ms(delay);
}

int main() {
    // Start up the LED strip
    strip.begin();

    // Update the strip, to start they are all 'off'
    strip.show();
    while (1) {
        year(10);
        wait_ms(5000);
        shield(10);
        wait_ms(5000);
        //rainbowCycle(100);
        colorWipe(strip.Color(127,127,0), 100);    // orange
        colorWipe(strip.Color(127,0,0), 100);        // red
        colorWipe(strip.Color(0, 127,0), 100);        // green
        colorWipe(strip.Color(0,0,127), 100);        // blue
        colorWipe(strip.Color(0,127,0), 100);        // green
        colorWipe(strip.Color(0,127,127), 100);    // teal
        colorWipe(strip.Color(0,0,127), 100);        // blue
        colorWipe(strip.Color(127,0,127), 100);    // violet
        
        colorWipe(strip.Color(0,0,0), 100);
    }
}
