//----------------------------------------------------------------------------
// The confidential and proprietary information contained in this file may
// only be used by a person authorised under and to the extent permitted
// by a subsisting licensing agreement from ARM Limited or its affiliates.
//
// (C) COPYRIGHT 2016 ARM Limited or its affiliates.
// ALL RIGHTS RESERVED
//
// This entire notice must be reproduced on all copies of this file
// and copies of this file may only be made by a person if such person is
// permitted to do so under the terms of a subsisting license agreement
// from ARM Limited or its affiliates.
//----------------------------------------------------------------------------

#include "mbed.h"
#include "C12832.h"


// GLOBAL VARIABLES HERE
C12832 lcd(D11, D13, D6, D7, D10);

DigitalOut led(D9, 1);
DigitalIn button(BUTTON, PullUp);


AnalogIn pot1(A0);
EventQueue queue;


// FUNCTION DEFINITIONS HERE
void lcd_print(const char* message) {
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf(message);
}

void read_potentiometer() {
    static float potentiometer_val = 0;
    if ((float)pot1 != potentiometer_val) {
        potentiometer_val = (float)pot1;
        char val[13];
        sprintf(val, "%.2f", potentiometer_val);
        lcd_print(val);
    }
}

void blink_led() {
    led = !led;
}
 
void set_blink_led() {
    static int blink_id = NULL;
    // Read the button
    int blink = !button.read();
    // If the button is pressed and the light is not currently blinking
    if (blink == 1 && blink_id == NULL) {
        // Add blinking the LED to event queue
        blink_id = queue.call_every(500, blink_led);
    }
    else if (blink == 0) {
        // Cancel the blinking event
        queue.cancel(blink_id);
        blink_id = NULL;
        led = 1;
    }
}
int main()
{
    // MAIN CODE HERE
    lcd_print("Hello World!");
    
    queue.call_every(100, read_potentiometer);
    while(1){
        wait_ms(100);
        queue.dispatch(0);
    }
    
    queue.call_every(100, set_blink_led);
}

