#include "mbed.h"
#include "time.h"
#define T 0.0001                                                                //Periode PWM 1 ms  


Serial pc(USBTX, USBRX);
DigitalIn Jack(D3);
DigitalIn FDC(D2);
AnalogIn capt1(A1);
AnalogIn capt2(A2);
AnalogIn capt3(A3);
AnalogIn capt4(A4);
PwmOut MoteurDroit(D6);
PwmOut MoteurGauche(D8);

int main()
{
    int valJack,valFDC,status=0,rcycl=80;
    float Valcpt1,Valcpt2,Valcpt3,Valcpt4;
    MoteurDroit.period(T);
    MoteurGauche.period(T);

    while (1) {
        valJack=Jack.read();                                                    //Lecture des capteurs
        valFDC=FDC.read();
        Valcpt1=capt1.read();                                                   //cpt1 : gauche || cpt2 : droit
        Valcpt2=capt2.read();
        Valcpt3=capt3.read();                                                   //cpt1 : gauche || cpt2 : droit
        Valcpt4=capt4.read();
      
        switch (status) {
            case 0:                                                             //Depart Jack
                if (valJack==1)                   status=2;
                break;
            case 1:                                                             //Retour status initial Jack
                if (valJack==0)                   status=0;
                break;
            case 2:                                                             //Si ligne capteur gauche, si ligne capteur droit
                if (valFDC==0)                    status=1;
                if ((Valcpt2<=0.4)||(Valcpt1<=0.4))         status=3;
                if ((Valcpt3<=0.4)||(Valcpt4<=0.4))             status=4;
                if (Valcpt2<=0.4 && Valcpt3<=0.4 )status=5;
                break;
            case 3:                                                            //Si capteur gauche hors ligne
                if (valFDC==0)                    status=1;
                if (Valcpt2>=0.4)                status=2;
                if ((Valcpt2<=0.4)&& (Valcpt3<=0.4)) status=5;
                break;
            case 4:                                                             //Si capteur droit hors ligne
                if (valFDC==0)                    status=1;
                if (Valcpt3>=0.4)                status=2;
                if (Valcpt2<=0.4 && Valcpt3<=0.4) status=5;
                break;
            case 5:                                                             //Si intersection : tout droit
                if (valFDC==0)                   status=1;
                if (Valcpt2>=0.4|| Valcpt3>=0.4) status=2;
                break;
        }

        switch (status) {
            case 0:                                                             //Arrêt moteurs, Jack IN
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                
                break;
            case 1:                                                             //Arrêt moteurs, FDC actif 1 fois
                MoteurDroit.write(1);
                MoteurGauche.write(1);

                break;
            case 2:

                MoteurDroit.pulsewidth_us(rcycl);                               //Mise en route moteurs en ligne droite
                MoteurGauche.pulsewidth_us(rcycl);

                break;
            case 3:  //tourner droite
                                                                 //Arrêt moteur droit (roue libre), redressement robot sur la droite
                    MoteurDroit.write(1);
                    MoteurGauche.pulsewidth_us(rcycl);
             
                

                break;
            case 4:       //tourner gauche                                                      //Arrêt moteur gauche (roue libre), redressement robot sur la gauche
                
                    MoteurDroit.pulsewidth_us(rcycl);
                    MoteurGauche.write(1);
                
        

                break;
            case 5:                                                             //Mise en route moteurs en ligne droitre
                MoteurDroit.pulsewidth_us(rcycl);
                MoteurGauche.pulsewidth_us(rcycl);

                break;
        }
    }
}