// ESE350 Final Project: Drue
#include "mbed.h"
#include "sd_card_player.h"
#include "SDFileSystem.h"

// Pin setup ////////////////////////////////////////////
SDFileSystem sd(p5, p6, p7, p8, "sd"); 
Timer timer;
Serial pc(USBTX, USBRX);
AnalogOut DACout(p18); //set up speaker
sd_card_player waveOut(&DACout); 

// Button Inputs
DigitalIn butC(p14); 
DigitalIn butD(p15);
DigitalIn butE(p16);
DigitalIn butF(p17);
DigitalIn butG(p19);
DigitalIn butA(p20); 
DigitalIn butB(p30); 
DigitalIn butCh(p29); 
DigitalIn butMode(p22); 

// For music
PwmOut speaker(p21);

// I2C to drive LED srips
I2C i2cLED(p9, p10); 

// LED for tests
DigitalOut indicator1(LED1);
DigitalOut indicator2(LED2);
DigitalOut indicator3(LED3);
DigitalOut indicator4(LED4);

/////////////////////////////////////////////////////////

// Variables 
bool switchPressed; 
bool notePressed; 
int prevNote; 
int mode; 
int numModes;
int score; 
bool needNote; 
bool pianoMode; 
bool hitNote; 
int targetNote; 
const int addr = 0b0100000 << 1; 
char cmd[2]; 

////////////////////////////////////////////////////////

void variableInit() {
    // modes
    mode = 0; 
    numModes = 4; 
    switchPressed = false;
    // keys
    notePressed = false; 
    prevNote = -1; 
    pianoMode = true; 
    // wack-a-mole
    needNote = true;
    score = 0; 
    targetNote = -1; 
    hitNote = false; 
}

void buttonSetup() {
    butC.mode(PullUp); 
    butD.mode(PullUp); 
    butE.mode(PullUp); 
    butF.mode(PullUp); 
    butG.mode(PullUp); 
    butA.mode(PullUp); 
    butB.mode(PullUp); 
    butCh.mode(PullUp); 
    butMode.mode(PullUp); 
}

void testSpeaker(){

    FILE *wave_file; 
    wave_file = fopen("/sd/notes/C4.wav","r"); //opens the music file
    if (wave_file == NULL){
        error("Could not open file for read");
    }
    pc.printf("begin play sound \n");
    waveOut.play(wave_file); //plays the music file)
    pc.printf("after play sound\n");
    fclose(wave_file);
}

void pressKey() {
    if (butC == 0 || butD == 0 || butE == 0 || butF == 0 || butG == 0 
                || butA == 0 || butB == 0 || butCh == 0) {
        // this if statement makes transitions between notes smoother
        // given that a note was already pressed before 
        if (prevNote != -1) {
            switch(prevNote) {
                case 0: 
                    if (butC == 1) {notePressed = false;}
                    break; 
                case 1: 
                    if (butD == 1) {notePressed = false;}
                    break; 
                case 2: 
                    if (butE == 1) {notePressed = false;}
                    break; 
                case 3: 
                    if (butF == 1) {notePressed = false;}
                    break; 
                case 4: 
                    if (butG == 1) {notePressed = false;}
                    break; 
                case 5: 
                    if (butA == 1) {notePressed = false;}
                    break; 
                case 6: 
                    if (butB == 1) {notePressed = false;}
                    break; 
                case 7: 
                    if (butCh == 1) {notePressed = false;}
                    break; 
            }
        }
        // wait(0.003); needed this before to give period time to update
        // this if statement initializes first note sound
        if (!notePressed) {
            if (butC == 0) {
                speaker.period(1.0/523.25);
                //testSpeaker();
                prevNote = 0; 
            } else if (butD == 0) {
                speaker.period(1.0/587.33);
                prevNote = 1; 
            } else if (butE == 0) {
                speaker.period(1.0/659.25); 
                prevNote = 2; 
            } else if (butF == 0) {
                speaker.period(1.0/698.46); 
                prevNote = 3; 
            } else if (butG == 0) {
                speaker.period(1.0/783.99);
                prevNote = 4; 
            } else if (butA == 0) {
                speaker.period(1.0/880.0);
                prevNote = 5; 
            } else if (butB == 0) {
                speaker.period(1.0/987.77);
                prevNote = 6; 
            } else if (butCh == 0) {
                speaker.period(1.0/1040.50);
                prevNote = 7; 
            }
        }
        notePressed = true; 
        if (pianoMode) {
            speaker = 0.5; 
        } else {
            if (prevNote == targetNote) {
                speaker = 0.5; 
                hitNote = true; 
            } 
        }
    } else {
            notePressed = false; 
            speaker = 0; 
            prevNote = -1; 
            if (!pianoMode) {
                if (hitNote) {
                    needNote = true; 
                    hitNote = false; 
                    score++; 
                }   
            }
    }
}

void lightIndicatorLED(int led) {
    indicator1 = 0; 
    indicator2 = 0; 
    indicator3 = 0; 
    indicator4 = 0; 

    switch(led) {
        case 0: 
            indicator1 = 1; 
            break; 
        case 1: 
            indicator2 = 1; 
            break; 
        case 2: 
            indicator3 = 1; 
            break; 
        case 3: 
            indicator4 = 1; 
            break; 
    }
}

void switchModeCheck() {
    if (butMode == 0) {
        if (!switchPressed) {
            switchPressed = true;
            prevNote = -1; 
            score = 0; 
            needNote = true; 
            targetNote = rand() % 8;
            
            pianoMode = false; 
            hitNote = false;
            
            mode++;
            if (mode == numModes) {
                mode = 0;
                pianoMode = true; 
            }
            lightIndicatorLED(mode); 
        }
    } else {
        switchPressed = false;
    }
}

void cycleSound() {
    static int count = 0; 
    if (count == 0){
        speaker.period(1.0/523.25);
    } else if (count == 1){
        speaker.period(1.0/587.33);
    } else if (count == 2){
        speaker.period(1.0/659.25);
    } else if (count == 3){
        speaker.period(1.0/698.46);
    } else if (count == 4){
        speaker.period(1.0/783.99);
    } else if (count == 5){
        speaker.period(1.0/880.0);
    } else if (count == 6){
        speaker.period(1.0/987.77);
    } else if (count == 7){
        speaker.period(1.0/1040.50);
    }
    speaker = 0.5;
    wait(0.2);
    speaker = 0; 
    count++;
    if (count == 8) {count = 0;}
    prevNote = count; 
}

void lightLED(int key) {
    switch(key) {
        case 0: 
            cmd[0] = 0xFE; 
            break; 
        case 1: 
            cmd[0] = 0xFD; 
            break; 
        case 2: 
            cmd[0] = 0xFB; 
            break; 
        case 3: 
            cmd[0] = 0xF7; 
            break; 
        case 4: 
            cmd[0] = 0x7F; 
            break; 
        case 5: 
            cmd[0] = 0xBF; 
            break; 
        case 6: 
            cmd[0] = 0xDF; 
            break; 
        case 7: 
            cmd[0] = 0xEF; 
            break; 
        default: 
            cmd[0] = 0xFF; 
    }
    i2cLED.write(addr, cmd, 1); 
}

void playWhackAMole() {
    if (needNote) {
        lightLED(-1); 
        wait(0.05);
        targetNote = rand() % 8;
        needNote = false; 
        lightLED(targetNote); 
    } 
    pressKey(); // rest of checks are in this function
}

//void testSd(){
//    pc.printf("Kevin sucks\n");   
//    mkdir("/sd/mydir", 0777);
//    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
//    if(fp == NULL) {
//        error("Could not open file for write\n");
//    }
//    fprintf(fp, "If you see this you owe Mirko a cookie hah!!");
//    fclose(fp); 
// 
//    pc.printf("Mirko wins\n");
//}

void playTeachPiano() {
    static int notes[] = {2,2,2,2,2,2,2,4,0,1,2,3,3,3,3,3,2,2,2,2,4,4,3,1,0};
    static int i = 0;
    if (needNote) {
        lightLED(-1); 
        wait(0.05);
        targetNote = notes[i];
        i++;
        if (i == 25) {
            i = 0; 
        }
        needNote = false;
        lightLED(targetNote);
   }
   pressKey(); // rest of checks are in this function
}

int main() {
    pc.baud (115200);
    variableInit(); 
    buttonSetup(); 
    wait(0.5);
        
    lightIndicatorLED(0); 
    
    while(1) {
        switchModeCheck(); 
        
        if (mode == 0) { // PIANO MODE
            pressKey();
            lightLED(prevNote); 
        } else if (mode == 1) { // WHACK A MOLE MODE
            playWhackAMole(); 
        } else if (mode == 2) {
            playTeachPiano(); 
        } else if (mode == 3) { // CYCLE SOUNDS MODE
            cycleSound(); 
            lightLED(prevNote); 
        }
    }
}