#include <mbed.h>

typedef struct uFMT_STRUCT {
    short comp_code;
    short num_channels;
    unsigned sample_rate;
    unsigned avg_Bps;
    short block_align;
    short sig_bps;
} FMT_STRUCT;


class sd_card_player {

public:

sd_card_player(AnalogOut *_dac);

/** the player function.
 *
 * @param wavefile  A pointer to an opened wave file
 */
void play(FILE *wavefile);

private:
    void dac_out(void);
    AnalogOut *wave_DAC;
    Ticker tick;
    unsigned short DAC_fifo[256];
    short DAC_wptr;
    volatile short DAC_rptr;
    short DAC_on;
};


