/* This is a short test program for AC4790-200 transceiver*/
/* We have radio's tx rx pin collected to mbed's p10 and p9 respectively, and have radio connected to external power 3.3v - 5v*, and GND
    only 4 pins are used from the radio*/
#include "mbed.h"
#define MAC_1 57
#define MAC_2 147      //             MAC for relay
#define MAC_3 98

#define MAC_4 57
#define MAC_5 149                     //MAC for GCS
#define MAC_6 98

Serial laird(p9, p10); //Creates a variable for serial comunication through pin 9 and 10
Serial pc(USBTX, USBRX);//Opens up serial communication through the USB port via the computer


int enter_cmd();
void get_respond();
int exit_cmd();
int api();
int write_cb();
void radio_send(char *to_send);
void radio_received(char *received);
void relay_send(char *to_send);

int main() {


    int i;
    char to_send[30] = {"ACD,100"};             //120byte max in data field, 4 byte a char??TEST, 30 chars max!!
    char received[30] = {'\0'};  

    wait(3);
/***************set up the serial interface parameters**********/
    laird.baud(57600);                      //set up the baud rate, needs to be the same as the baud rate of the radio
    laird.format(8, Serial::None, 1);       //set up the format, 8 bits, none parity, 1 stop bit

    
    wait(1);
/*************enter command mode *****************/

    while(!enter_cmd()) ;    //send hex command to enter the command mode
    
    /*the supposed hex respond after enter the command mode : cc 43 4f 4d*/
    pc.printf("enter cmd respond: ");
    for( i = 0; i < 4; i++)
        get_respond();     
    wait_ms(500);
    pc.printf("\n\r");
    
 /*************change channel number**************/
    laird.putc('\xcc');
    laird.putc('\x01');
    laird.putc('\x10');
    
    pc.printf("change channle respond: ");
    get_respond();
    get_respond();
    pc.printf("\r\n");   
    
/*************configure API control ****************/
    while(!api());              //send hex command to configure API control
    
    pc.printf("API control respond: ");         //expected respond: cc 13
    for( i = 0; i <2; i++)
        get_respond();
    wait_ms(500);
    pc.printf("\n\r");
    
/************** EEPROM write control 1 byte********/
    while(!write_cb());
    
    pc.printf("write control byte respond: ");      //expected respond: 56 01 41
    for( i = 0; i <3; i++)
        get_respond();
    wait_ms(500);
    pc.printf("\n\r");
    
/************read destination MAC address*******/
    laird.putc('\xcc');
    laird.putc('\x11');
    
    pc.printf("Destination MAC address respond: ");
    for(i = 0; i< 4; i++)
        get_respond();
    wait_ms(500);
    pc.printf("\n\r");
    
/**************read own MAC address************/
    laird.putc('\xcc');
    laird.putc('\xc0');
    laird.putc('\x80');
    laird.putc('\x06');
    
    pc.printf("Own MAC address: ");
    for(i = 0; i < 9; i++)
        get_respond();
    wait_ms(500);
    pc.printf("\n\r");
        
/************write destination MAC address*********/

/*
    laird.putc('\xcc');         //ground station mac address: 61 78 32
    laird.putc('\x10');
    laird.putc(MAC_1);
    laird.putc(MAC_2);
    laird.putc(MAC_3);
   
    
    pc.printf("after write MAC respond: ");
    for(i = 0; i < 4; i++)
        get_respond();
    wait_ms(500);
    pc.printf("\n\r");
 */   
/***************read DES key**********************/
    laird.putc('\xcc');
    laird.putc('\xc0');
    laird.putc('\xd0');
    laird.putc('\x07');
    
    pc.printf("DES key: ");
    for(i = 0; i < 10; i++)
        get_respond();
    wait_ms(500);
    pc.printf("\n\r");
    
/**************exit command mode ******************/
    while(!exit_cmd());         //send hex command to exit the command mode
    
    /*the expected hex respond after exit the command mode: cc 44 41 54*/
    pc.printf("exit cmd respond: ");
    for( i = 0; i < 4; i++)
        get_respond();
    wait_ms(500);
    pc.printf("\n\r");
    
/****************communication ****************/
/*
while(1){
    radio_send(to_send);
    wait(5);
//    wait(1);
//    pc.printf("done sending\r\n");
}   
*/
/*
while(1){
    relay_send(to_send);
    wait(5);
    }
 */   
/*    radio_received(received);
    for(i = 0; received[i] != '\0'; i++)
    {    
        pc.printf("%x ", received[i]);
        received[i] = '\0';
        
     }
     pc.printf("\r\n");
     */    

while(1)
{
    radio_received(received);
    for(i = 0; received[i] != '\0'; i++)
    {    
        pc.printf("%x ", received[i]);
        received[i] = '\0';
        
     }
     pc.printf("\r\n");
     
     wait(5);
     radio_send(to_send);
     pc.printf("reply send\r\n");
}

/*    
  
while(1)
 {   
    radio_send(to_send);
    wait(1);
    pc.printf("done sending\r\n");
  }  
  */

/*    
    while(1)
    {
        i = 0;

        pc.printf("done1 ");
        radio_received(received);
        pc.printf("done2 ");
        while(received[i] != '\0')
            pc.putc( received[i++] );
        wait(1);
                for(i = 0; i < 30; i++)
            received[i] = '\0';
    } 
*/
}



/*************funtions used with radio****************/
int enter_cmd()
{
            if (laird.writeable()) {
            //enter cmd mode, hex value: 0x41 0x54 0x2B 0x2B 0x2B 0x0D          
            laird.putc('\x41');
            laird.putc('\x54');
            laird.putc('\x2b');
            laird.putc('\x2b');
            laird.putc('\x2b');
            laird.putc('\x0d');
            return 1;
            }
            else return 0;
}

void get_respond()
{
    while(laird.readable() == 0);           //wait until there is char to read
    pc.printf("%x ", laird.getc());         //print out the char in hex form
}    

int exit_cmd()
{
           //exit cmd mode, hex value: 0xcc 0x41 0x54 0x4f 0x0d
            if(laird.writeable()) 
           {            
            laird.putc('\xcc');
            laird.putc('\x41');
            laird.putc('\x54');
            laird.putc('\x4f');
            laird.putc('\x0d');
            return 1;
           }
           
           else return 0;
    
}

int api()
{
            if(laird.writeable()) 
           {            
            laird.putc('\xcc');
            laird.putc('\x17');
            laird.putc('\x13');
            return 1;
           }
           
           else return 0;
}

int write_cb()
{
           if(laird.writeable()) 
           {            
            laird.putc('\xcc');
            laird.putc('\xc1');
            laird.putc('\x56');
            laird.putc('\x01');
            laird.putc('\x41');
            return 1;
           }
           
           else return 0;
}

//function used to send data over the radio, 
void radio_send(char *to_send)
{
    int i = 0;
    for( i = 0; to_send[i] != '\0'; i++);
    
    laird.putc('\x81');
    laird.putc(i);   
    laird.putc(8);
    laird.putc(4); 
    laird.putc(MAC_4);
    laird.putc(MAC_5);
    laird.putc(MAC_6);
    
    for( i = 0; to_send[i] != '\0'; i++)
       laird.putc(to_send[i]);
    pc.printf("sent");
}

void relay_send(char *to_send)
{
    int i = 0;
    for( i = 0; to_send[i] != '\0'; i++);

    laird.putc('\x81');
    laird.putc(i + 3);
    laird.putc(8);
    laird.putc(4);
    laird.putc(MAC_1);
    laird.putc(MAC_2);
    laird.putc(MAC_3);
    laird.putc(MAC_4);
    laird.putc(MAC_5);
    laird.putc(MAC_6);
    for( i = 0; to_send[i] != '\0'; i++)
       laird.putc(to_send[i]);
//    laird.putc('\0');
//    pc.printf("sent");
}
   

void radio_received(char *received)
{
    int size = 0;
    int i = 0;
    
    while(laird.readable() == 0);

    if( laird.getc() == '\x81')
    {
 
        size = laird.getc();           
        //throw away next 5 chars
        pc.printf("%x ", laird.getc());
        pc.printf("%x ", laird.getc());
        pc.printf("%x ", laird.getc());
        pc.printf("%x ", laird.getc());
        pc.printf("%x ", laird.getc());

        for( i = 0; i < size; i++)
        {    received[i] = laird.getc();

            }
        received[i + 1] = '\0';             //used to mark the ending of data
    } 
 
}
