#include "mbed.h"
#include "QEI.h"
#include "BiQuad.h"
#ifndef M_PI
    #define M_PI 3.141592653589793238462643383279502884L // Pi
#endif

class motor {
    private:
        PwmOut pwm;     // pwm port
        DigitalOut dir;     // direction port
        QEI sense;          // encoder
        
        BiQuad bq1, bq2;    // Declare biquads for filtering D
        BiQuadChain bqc;    // Declare biquad chains for filtering D

        double integral;
        double olderr;
        double P, I, D;
        bool flip;

          
    public:
        motor(PinName p_pwm, PinName p_dir, PinName p_senseA, PinName p_senseB, double p, double i, double d, bool flipped);
        void setSpeed(float val);
        double getPosition(void);
        void PID(double setpoint, double dt);
        ~motor();
        
};