#include "mbed.h"
#include "QEI.h"
#include "MODSERIAL.h"


MODSERIAL pc(USBTX, USBRX);
DigitalOut motor1dir(D7);
PwmOut motor1pwm(D6);

void setmotor1(float val){
    if (val>=0){
        if (val > 1) {
            val = 1.0f;
        }
        motor1dir.write(1);
        motor1pwm.write(val);
    }
    else {
        if (val < -1) {
            val = -1.0f;
        }
        motor1dir.write(0);
        motor1pwm.write(fabs(val));
    }
    printf("pwm: %.2f", fabs(val));
}

int main()
{
    float w = 0.05f;
    
    motor1pwm.period_us(1000);
    pc.baud(115200);
    while (true) {
        for(float i=0;i<=1;i=i+0.1f){
            printf("i: %.2f\n\r",i);
            setmotor1(i);
            wait(w);
        }
        for(float i=1;i>=-1;i=i-0.1f){
            printf("i: %.2f\n\r",i);
            setmotor1(i);
            wait(w);
        }
        for(float i=-1;i<=0;i=i+0.1f){
            printf("i: %.2f\n\r",i);
            setmotor1(i);
            wait(w);
        }
        
    }
}