#include "mbed.h"
#include "BiQuad.h"
#include "math.h"
#define EMG_DEBUG
#ifndef M_PI
#define M_PI    3.14159265358979323846
#endif

#define EMG_THRESHOLD   0.2

class EMG_input {
    private:
        AnalogIn emg0;     // Declare port
        BiQuad bq1, bq2, bq3, bq4, bq5, bq6, bq7, bq8;  // Declare biquads
        BiQuadChain bqc1, bqc2;  // Declare biquad chains
        double maxsig;  // Maximum signal value, used for calibrating output between 0 and 1.
          
    public:
        double e0, e0f, e0flow, discrete;
        EMG_input(PinName pin);
        void tick(void);
        bool read(void);
        ~EMG_input();
        
};